/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.unit;

import java.util.List;
import javax.measure.UnitConverter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;
import tech.units.tck.TCKSetup;
import tech.units.tck.util.TestUtils;

@SpecVersion(spec="JSR 385", version="2.2")
public class UnitConversionTest {
    private static final String SECTION = "4.2.3";

    @Test(groups={"core"}, description="4.2.3 Ensure at least one UnitConverter implementation is available/registered.")
    @SpecAssertion(section="4.2.3", id="423-A1")
    public void testEnsureGotConverters() {
        Assert.assertNotNull((Object)TCKSetup.getConfiguration(), (String)"TCK Configuration not available.");
        MatcherAssert.assertThat((String)"No UnitConverter implementation found.", TCKSetup.getConfiguration().getUnitConverters4Test(), (Matcher)Is.is((Matcher)IsNot.not((Matcher)Matchers.empty())));
    }

    @Test(groups={"core"}, description="4.2.3 Ensure registered UnitConverter classes override equals.")
    @SpecAssertion(section="4.2.3", id="423-A2")
    public void testUnitConverterEquals() {
        for (UnitConverter converter : TCKSetup.getConfiguration().getUnitConverters4Test()) {
            Class<?> type = converter.getClass();
            TestUtils.testHasPublicMethod("Section 4.2.3", type, true, Boolean.TYPE, "equals", Object.class);
        }
    }

    @Test(groups={"core"}, description="4.2.3 Ensure registered UnitConverter classes override hashCode.")
    @SpecAssertion(section="4.2.3", id="423-A3")
    public void testUnitConverterHashcode() {
        for (UnitConverter converter : TCKSetup.getConfiguration().getUnitConverters4Test()) {
            Class<?> type = converter.getClass();
            TestUtils.testHasPublicMethod("Section 4.2.3", type, true, Integer.TYPE, "hashCode", new Class[0]);
        }
    }

    @Test(groups={"core"}, description="4.2.3 Ensure the inverse() method is implemented.")
    @SpecAssertion(section="4.2.3", id="423-A4")
    public void testUnitConverterInvert() {
        for (UnitConverter converter : TCKSetup.getConfiguration().getUnitConverters4Test()) {
            Class<?> type = converter.getClass();
            TestUtils.testHasPublicMethod("Section 4.2.3", type, "inverse");
        }
    }

    @Test(groups={"core"}, description="4.2.3 Ensure the isIdentity() method is implemented.")
    @SpecAssertion(section="4.2.3", id="423-A5")
    public void testUnitConverterIsIdentity() {
        for (UnitConverter converter : TCKSetup.getConfiguration().getUnitConverters4Test()) {
            Class<?> type = converter.getClass();
            TestUtils.testHasPublicMethod("Section 4.2.3", type, "isIdentity");
        }
    }

    @Test(groups={"core"}, description="4.2.3 Ensure the isLinear() method is implemented.")
    @SpecAssertion(section="4.2.3", id="423-A6")
    public void testUnitConverterIsLinear() {
        for (UnitConverter converter : TCKSetup.getConfiguration().getUnitConverters4Test()) {
            Class<?> type = converter.getClass();
            TestUtils.testHasPublicMethod("Section 4.2.3", type, "isLinear");
        }
    }

    @Test(groups={"core"}, description="4.2.3 Ensure the convert() method is implemented.")
    @SpecAssertion(section="4.2.3", id="423-A7")
    public void testUnitConverterConvert() {
        for (UnitConverter converter : TCKSetup.getConfiguration().getUnitConverters4Test()) {
            Class<?> type = converter.getClass();
            TestUtils.testHasPublicMethod("Section 4.2.3", type, Number.class, "convert", Number.class);
        }
    }

    @Test(groups={"core"}, description="4.2.3 Ensure the convert() method is implemented.")
    @SpecAssertion(section="4.2.3", id="423-A8")
    public void testUnitConverterConvertWithDouble() {
        for (UnitConverter converter : TCKSetup.getConfiguration().getUnitConverters4Test()) {
            Class<?> type = converter.getClass();
            TestUtils.testHasPublicMethod("Section 4.2.3", type, Double.TYPE, "convert", Double.TYPE);
        }
    }

    @Test(groups={"core"}, description="4.2.3 Ensure the concatenate() method is implemented.")
    @SpecAssertion(section="4.2.3", id="423-A9")
    public void testUnitConverterConcatenate() {
        for (UnitConverter converter : TCKSetup.getConfiguration().getUnitConverters4Test()) {
            Class<?> type = converter.getClass();
            TestUtils.testHasPublicMethod("Section 4.2.3", type, UnitConverter.class, "concatenate", UnitConverter.class);
        }
    }

    @Test(groups={"core"}, description="4.2.3 Ensure the getConversionSteps() method is implemented.")
    @SpecAssertion(section="4.2.3", id="423-A10")
    public void testUnitConverterGetConversionSteps() {
        for (UnitConverter converter : TCKSetup.getConfiguration().getUnitConverters4Test()) {
            Class<?> type = converter.getClass();
            TestUtils.testHasPublicMethod("Section 4.2.3", type, List.class, "getConversionSteps", new Class[0]);
        }
    }
}

