/*
 * Decompiled with CFR 0.152.
 */
package tech.units.tck.tests.unit;

import javax.measure.Prefix;
import javax.measure.Unit;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;
import tech.units.tck.TCKSetup;
import tech.units.tck.util.TestUtils;

@SpecVersion(spec="JSR 385", version="2.2")
public class UnitInterfaceTest {
    private static final String SECTION_NUM1 = "4.2.1";
    private static final String SECTION_NUM2 = "4.2.1.2";

    @Test(groups={"core"}, description="4.2.1 Ensure registered Unit classes override equals.")
    @SpecAssertion(section="4.2.1", id="421-A1")
    public void testEquals() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1", type, true, Boolean.TYPE, "equals", Object.class);
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure registered Unit classes implement getDimension.")
    @SpecAssertion(section="4.2.1", id="421-A2")
    public void testGetDimension() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1", type, "getDimension");
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure registered Unit classes implement getSystemUnit.")
    @SpecAssertion(section="4.2.1", id="421-A3")
    public void testGetSystemUnit() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1", type, "getSystemUnit");
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure registered Unit classes implement getBaseUnits.")
    @SpecAssertion(section="4.2.1", id="421-A4")
    public void testGetBaseUnits() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1", type, "getBaseUnits");
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure registered Unit classes implement getName.")
    @SpecAssertion(section="4.2.1", id="421-A5")
    public void testGetName() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1", type, "getName");
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure registered Unit classes implement getSymbol.")
    @SpecAssertion(section="4.2.1", id="421-A6")
    public void testGetSymbol() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1", type, "getSymbol");
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure registered Unit classes override hashCode.")
    @SpecAssertion(section="4.2.1", id="421-A7")
    public void testHashcode() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1", type, Integer.TYPE, "hashCode", new Class[0]);
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure registered Unit classes implement isEquivalentTo.")
    @SpecAssertion(section="4.2.1", id="421-A8")
    public void testIsEquivalentTo() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1", type, "isEquivalentTo", true);
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure registered Unit classes override toString.")
    @SpecAssertion(section="4.2.1", id="421-A9")
    public void testToString() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1", type, false, String.class, "toString", new Class[0]);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.1 Ensure the alternate() operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42121-A1")
    public void testUnit42121A1_Alternate() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.1", type, "alternate", true);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.1 Ensure the divide(Unit) operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42121-A2")
    public void testUnit42121A2_Divide() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.1", type, Unit.class, "divide", Unit.class);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.1 Ensure the divide(double) operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42121-A3")
    public void testUnit42121A3_DivideByDouble() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.1", type, Unit.class, "divide", Double.TYPE);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.1 Ensure the divide(Number) operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42121-A4")
    public void testUnit42121A4_DivideByNumber() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.1", type, Unit.class, "divide", Number.class);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.1 Ensure the multiply() operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42121-A5")
    public void testUnit42121A5_Multiply() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.1", type, Unit.class, "multiply", Unit.class);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.1 Ensure the multiply(double) operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42121-A6")
    public void testUnit42121A6_MultiplyByDouble() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.1", type, Unit.class, "multiply", Double.TYPE);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.1 Ensure the multiply(Number) operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42121-A7")
    public void testUnit42121A7_MultiplyByNumber() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.1", type, Unit.class, "multiply", Number.class);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.1 Ensure the prefix() operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42121-A8")
    public void testUnit42121A8_Prefix() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.1", type, false, Unit.class, "prefix", Prefix.class);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.1 Ensure the shift(double) operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42121-A9")
    public void testUnit42121A9_ShiftByDouble() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.1", type, Unit.class, "shift", Double.TYPE);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.1 Ensure the shift(Number) operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42121-A10")
    public void testUnit42121A10_ShiftByNumber() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.1", type, Unit.class, "shift", Number.class);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.2 Ensure the pow() operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42122-A1")
    public void testUnit42122Pow() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.2", type, "pow", true);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.2 Ensure the root() operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42122-A2")
    public void testUnit42122Root() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.2", type, "root", true);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.2 Ensure the transform() operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42122-A3")
    public void testUnit42122Transform() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.2", type, "transform", true);
        }
    }

    @Test(groups={"core"}, description="4.2.1.2.3 Ensure the inverse() operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42123-A1")
    public void testUnit42123Inverse() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.3", type, "inverse", false);
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure the isCompatible() operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42124-A1")
    public void testUnit4221IsCompatible() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.4", type, "isCompatible", true);
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure the asType() operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42124-A2")
    public void testUnit4222AsType() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.4", type, "asType", true);
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure the getConverterTo() operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42124-A3")
    public void testUnit4223GetConverterTo() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.4", type, "getConverterTo", true);
        }
    }

    @Test(groups={"core"}, description="4.2.1 Ensure the getConverterToAny() operation is implemented.")
    @SpecAssertion(section="4.2.1.2", id="42124-A4")
    public void testUnit4224GetConverterToAny() {
        for (Class type : TCKSetup.getConfiguration().getUnitClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1.2.4", type, "getConverterToAny", true);
        }
    }
}

