/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.measure.UnitConverter;
import tech.uom.seshat.AbstractConverter;
import tech.uom.seshat.IdentityConverter;

final class ConcatenatedConverter
extends AbstractConverter {
    private static final long serialVersionUID = 6506147355157815065L;
    private final UnitConverter c1;
    private final UnitConverter c2;
    private transient ConcatenatedConverter inverse;

    ConcatenatedConverter(UnitConverter unitConverter, UnitConverter unitConverter2) {
        this.c1 = unitConverter;
        this.c2 = unitConverter2;
    }

    @Override
    public boolean isIdentity() {
        return this.c1.isIdentity() && this.c2.isIdentity();
    }

    @Override
    public boolean isLinear() {
        return this.c1.isLinear() && this.c2.isLinear();
    }

    public synchronized UnitConverter inverse() {
        if (this.inverse == null) {
            this.inverse = new ConcatenatedConverter(this.c2.inverse(), this.c1.inverse());
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    public double convert(double d) {
        return this.c2.convert(this.c1.convert(d));
    }

    @Override
    public Number convert(Number number) {
        return this.c2.convert(this.c1.convert(number));
    }

    @Override
    public double derivative(double d) {
        return ConcatenatedConverter.derivative(this.c1, d) * ConcatenatedConverter.derivative(this.c2, this.c1.convert(d));
    }

    @Override
    public UnitConverter concatenate(UnitConverter unitConverter) {
        Objects.requireNonNull(unitConverter);
        if (this.equals(unitConverter.inverse())) {
            return IdentityConverter.INSTANCE;
        }
        return this.c2.concatenate(this.c1.concatenate(unitConverter));
    }

    @Override
    public List<UnitConverter> getConversionSteps() {
        ArrayList<UnitConverter> arrayList = new ArrayList<UnitConverter>();
        arrayList.addAll(this.c1.getConversionSteps());
        arrayList.addAll(this.c2.getConversionSteps());
        return arrayList;
    }

    public int hashCode() {
        return this.c1.hashCode() + 31 * this.c2.hashCode() ^ 0x68875F19;
    }

    public boolean equals(Object object) {
        if (object instanceof ConcatenatedConverter) {
            ConcatenatedConverter concatenatedConverter = (ConcatenatedConverter)object;
            return this.c1.equals((Object)concatenatedConverter.c1) && this.c2.equals((Object)concatenatedConverter.c2);
        }
        return false;
    }
}

