/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import tech.uom.seshat.Quantities;
import tech.uom.seshat.UnitFormat;
import tech.uom.seshat.resources.Errors;

public class QuantityFormat
extends Format
implements javax.measure.format.QuantityFormat {
    private static final long serialVersionUID = 1014042719969477503L;
    public static final char SEPARATOR = '\u202f';
    protected final NumberFormat numberFormat;
    protected final UnitFormat unitFormat;

    public QuantityFormat(Locale locale) {
        Objects.requireNonNull(locale);
        this.numberFormat = NumberFormat.getNumberInstance(locale);
        this.unitFormat = new UnitFormat(locale);
    }

    public QuantityFormat(NumberFormat numberFormat, UnitFormat unitFormat) {
        Objects.requireNonNull(numberFormat);
        Objects.requireNonNull(unitFormat);
        this.numberFormat = numberFormat;
        this.unitFormat = unitFormat;
    }

    public boolean isLocaleSensitive() {
        return true;
    }

    public String format(Quantity<?> quantity) {
        return this.format(quantity, new StringBuffer(), null).toString();
    }

    public Appendable format(Quantity<?> quantity, Appendable appendable) throws IOException {
        if (appendable instanceof StringBuffer) {
            return this.format(quantity, (StringBuffer)appendable, null);
        }
        return appendable.append(this.format(quantity, new StringBuffer(), null));
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Quantity quantity = (Quantity)object;
        if (fieldPosition == null) {
            fieldPosition = new FieldPosition(0);
        }
        stringBuffer = this.numberFormat.format(quantity.getValue(), stringBuffer, fieldPosition).append('\u202f');
        stringBuffer = this.unitFormat.format(quantity.getUnit(), stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public Quantity<?> parse(CharSequence charSequence) throws MeasurementParseException {
        return this.parse(charSequence, new ParsePosition(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Quantity<?> parse(CharSequence charSequence, ParsePosition parsePosition) throws MeasurementParseException {
        String string;
        int n;
        int n2 = parsePosition.getIndex();
        if (n2 == 0 || charSequence instanceof String) {
            n = 0;
            string = charSequence.toString();
        } else {
            n = n2;
            string = charSequence.subSequence(n2, charSequence.length()).toString();
            parsePosition.setIndex(0);
        }
        try {
            Unit<?> unit;
            Number number = this.numberFormat.parse(string, parsePosition);
            if (number != null && (unit = this.unitFormat.parse(string, parsePosition)) != null) {
                Object obj = Quantities.create(number.doubleValue(), unit);
                return obj;
            }
        }
        finally {
            if (n != 0) {
                parsePosition.setIndex(parsePosition.getIndex() + n);
                int n3 = parsePosition.getErrorIndex();
                if (n3 >= 0) {
                    parsePosition.setErrorIndex(n3 + n);
                }
            }
        }
        throw new MeasurementParseException(Errors.format((short)20, charSequence), charSequence, parsePosition.getErrorIndex());
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        Number number = this.numberFormat.parse(string, parsePosition);
        if (number != null) {
            try {
                Unit<?> unit = this.unitFormat.parse(string, parsePosition);
                if (unit != null) {
                    return Quantities.create(number.doubleValue(), unit);
                }
            }
            catch (MeasurementParseException measurementParseException) {
                Errors.getLogger().log(System.Logger.Level.DEBUG, (Object)measurementParseException);
            }
            parsePosition.setIndex(n);
        }
        return null;
    }

    @Override
    public QuantityFormat clone() {
        QuantityFormat quantityFormat = (QuantityFormat)super.clone();
        try {
            quantityFormat.setFinalField("numberFormat", this.numberFormat);
            quantityFormat.setFinalField("unitFormat", this.unitFormat);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw (InaccessibleObjectException)new InaccessibleObjectException().initCause(reflectiveOperationException);
        }
        return quantityFormat;
    }

    private void setFinalField(String string, Format format) throws ReflectiveOperationException {
        Field field = QuantityFormat.class.getDeclaredField(string);
        field.setAccessible(true);
        field.set(this, format.clone());
    }
}

