/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.spi.SystemOfUnits;
import tech.uom.seshat.AbstractUnit;
import tech.uom.seshat.ConventionalUnit;
import tech.uom.seshat.SystemUnit;
import tech.uom.seshat.UnitDimension;
import tech.uom.seshat.Units;
import tech.uom.seshat.math.Fraction;
import tech.uom.seshat.util.WeakValueHashMap;

final class UnitRegistry
implements SystemOfUnits,
Serializable {
    private static final long serialVersionUID = -84557361079506390L;
    static final byte PREFIXABLE = 1;
    static final byte SI = 2;
    static final byte ACCEPTED = 4;
    static final byte CGS = 8;
    static final byte IMPERIAL = 16;
    static final byte OTHER = 32;
    private static final Map<Object, Object> HARD_CODED = new HashMap<Object, Object>(256);
    private static final WeakValueHashMap<Object, Object> USER_DEFINED = new WeakValueHashMap(Object.class);
    final String name;
    private final int includes;
    private transient Set<Unit<?>> units;

    static void init(Map<UnitDimension, Fraction> map, UnitDimension unitDimension) {
        assert (!Units.initialized) : unitDimension.symbol;
        if (HARD_CODED.put(map, unitDimension) != null) {
            throw new AssertionError(unitDimension.symbol);
        }
    }

    static <Q extends Quantity<Q>> SystemUnit<Q> init(SystemUnit<Q> systemUnit) {
        assert (!Units.initialized) : systemUnit;
        String string = systemUnit.getSymbol();
        int n = HARD_CODED.put(systemUnit.dimension, systemUnit) == null ? 0 : 1;
        n |= HARD_CODED.put(systemUnit.quantity, systemUnit) == null ? 0 : 2;
        if (string != null) {
            n |= HARD_CODED.put(string, systemUnit) == null ? 0 : 4;
        }
        if (systemUnit.epsg != 0) {
            n |= HARD_CODED.put(systemUnit.epsg, systemUnit) == null ? 0 : 8;
        }
        assert (UnitRegistry.filter(n, systemUnit, string) == 0) : systemUnit;
        return systemUnit;
    }

    private static int filter(int n, SystemUnit<?> systemUnit, String string) {
        if (systemUnit.dimension.isDimensionless()) {
            n &= 0xFFFFFFFC;
        }
        if ("cd".equals(string) || "Hz".equals(string)) {
            n &= 0xFFFFFFFE;
        }
        return string == null || string.isEmpty() ? 0 : n;
    }

    static <Q extends Quantity<Q>> ConventionalUnit<Q> init(ConventionalUnit<Q> conventionalUnit) {
        assert (!Units.initialized) : conventionalUnit;
        if (HARD_CODED.put(conventionalUnit.getSymbol(), conventionalUnit) == null && (conventionalUnit.epsg == 0 || HARD_CODED.put(conventionalUnit.epsg, conventionalUnit) == null)) {
            return conventionalUnit;
        }
        throw new AssertionError(conventionalUnit);
    }

    static void alias(Unit<?> unit, Comparable<?> comparable) {
        assert (!Units.initialized) : unit;
        if (HARD_CODED.put(comparable, unit) != null) {
            throw new AssertionError(unit);
        }
    }

    static Object putIfAbsent(Object object, Object object2) {
        assert (Units.initialized) : object2;
        Object object3 = HARD_CODED.get(object);
        if (object3 == null) {
            object3 = USER_DEFINED.putIfAbsent(object, object2);
        }
        return object3;
    }

    static Object get(Object object) {
        Object object2 = HARD_CODED.get(object);
        if (object2 == null) {
            object2 = USER_DEFINED.get(object);
        }
        return object2;
    }

    UnitRegistry(String string, int n) {
        this.name = string;
        this.includes = n;
    }

    public String getName() {
        return this.name;
    }

    public <Q extends Quantity<Q>> Unit<Q> getUnit(Class<Q> clazz) {
        return Units.get(clazz);
    }

    public Unit<?> getUnit(String string) {
        try {
            return Units.valueOf(string);
        }
        catch (MeasurementParseException measurementParseException) {
            System.getLogger("tech.uom.seshat").log(System.Logger.Level.DEBUG, (Object)measurementParseException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Unit<?>> getUnits() {
        if (Units.initialized) {
            UnitRegistry unitRegistry = this;
            synchronized (unitRegistry) {
                if (this.units == null) {
                    this.units = new HashSet();
                    for (Object object : HARD_CODED.values()) {
                        if (!(object instanceof AbstractUnit)) continue;
                        AbstractUnit abstractUnit = (AbstractUnit)object;
                        if ((abstractUnit.scope & this.includes) == 0) continue;
                        this.units.add(abstractUnit);
                    }
                    this.units = Collections.unmodifiableSet(this.units);
                }
            }
        }
        return this.units;
    }

    public Set<Unit<?>> getUnits(Dimension dimension) {
        Objects.requireNonNull(dimension);
        HashSet hashSet = new HashSet();
        for (Unit<?> unit : this.getUnits()) {
            if (!dimension.equals((Object)unit.getDimension())) continue;
            hashSet.add(unit);
        }
        return hashSet;
    }
}

