/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.spi.FormatService;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import tech.uom.seshat.AbstractConverter;
import tech.uom.seshat.DefaultQuantityFactory;
import tech.uom.seshat.QuantityFormat;
import tech.uom.seshat.ScalarFallback;
import tech.uom.seshat.UnitFormat;
import tech.uom.seshat.UnitRegistry;
import tech.uom.seshat.Units;
import tech.uom.seshat.resources.Errors;

public class UnitServices
extends ServiceProvider
implements SystemOfUnitsService,
FormatService {
    private final UnitRegistry[] systems = new UnitRegistry[]{new UnitRegistry("SI", 2), new UnitRegistry("SI + accepted", 6), new UnitRegistry("Imperial", 16), new UnitRegistry("CGS", 8), new UnitRegistry("SI + other", -1)};

    public SystemOfUnits getSystemOfUnits() {
        return this.systems[this.systems.length - 1];
    }

    public SystemOfUnits getSystemOfUnits(String string) {
        Objects.requireNonNull(string);
        for (UnitRegistry unitRegistry : this.systems) {
            if (!string.equalsIgnoreCase(unitRegistry.name)) continue;
            return unitRegistry;
        }
        return null;
    }

    public Collection<SystemOfUnits> getAvailableSystemsOfUnits() {
        return Collections.unmodifiableList(Arrays.asList(this.systems));
    }

    public SystemOfUnitsService getSystemOfUnitsService() {
        return this;
    }

    public javax.measure.format.UnitFormat getUnitFormat() {
        return new UnitFormat(Locale.getDefault(Locale.Category.FORMAT));
    }

    public javax.measure.format.UnitFormat getUnitFormat(String string) {
        UnitFormat.Style style;
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        string = string.toUpperCase(locale).trim();
        try {
            style = UnitFormat.Style.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Errors.getLogger().log(System.Logger.Level.DEBUG, illegalArgumentException);
            return null;
        }
        UnitFormat unitFormat = new UnitFormat(locale);
        unitFormat.setStyle(style);
        return unitFormat;
    }

    public javax.measure.format.UnitFormat getUnitFormat(String string, String string2) {
        return this.getUnitFormat(string);
    }

    public javax.measure.format.QuantityFormat getQuantityFormat() {
        return new QuantityFormat(Locale.getDefault(Locale.Category.FORMAT));
    }

    public javax.measure.format.QuantityFormat getQuantityFormat(String string) {
        javax.measure.format.UnitFormat unitFormat = this.getUnitFormat(string);
        if (unitFormat instanceof UnitFormat) {
            return new QuantityFormat(NumberFormat.getInstance(), (UnitFormat)unitFormat);
        }
        return null;
    }

    public Set<String> getAvailableFormatNames(FormatService.FormatType formatType) {
        HashSet<String> hashSet = new HashSet<String>(4);
        for (UnitFormat.Style style : UnitFormat.Style.values()) {
            hashSet.add(style.name());
        }
        return hashSet;
    }

    public FormatService getFormatService() {
        return this;
    }

    public <Q extends Quantity<Q>> QuantityFactory<Q> getQuantityFactory(final Class<Q> clazz) {
        Objects.requireNonNull(clazz);
        Object object = Units.get(clazz);
        if (object == null) {
            object = clazz != null ? new DefaultQuantityFactory<Q>(){

                @Override
                public Quantity<Q> create(Number number, Unit<Q> unit) {
                    return ScalarFallback.factory(AbstractConverter.doubleValue(number), unit, clazz);
                }
            } : new DefaultQuantityFactory();
        }
        return object;
    }
}

