/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat.math;

import java.io.Serializable;
import tech.uom.seshat.util.WeakHashSet;

public final class Fraction
extends Number
implements Comparable<Fraction>,
Serializable {
    private static final long serialVersionUID = -4501644254763471216L;
    private static final WeakHashSet<Fraction> POOL = new WeakHashSet<Fraction>(Fraction.class);
    public final int numerator;
    public final int denominator;
    private static final char[][] UNICODES = new char[][]{{'\u0000', '\u0000', '\u2189'}, {'\u00bd', '\u2153', '\u00bc', '\u2155', '\u2159', '\u2150', '\u215b', '\u2151', '\u2152'}, {'\u2154', '\u0000', '\u2156'}, {'\u00be', '\u2157', '\u0000', '\u0000', '\u215c'}, {'\u2158'}, {'\u215a', '\u0000', '\u215d'}, new char[0], {'\u215e'}};

    public Fraction(int n, int n2) {
        this.numerator = n;
        this.denominator = n2;
    }

    public Fraction unique() {
        return POOL.unique(this);
    }

    public Fraction simplify() {
        return this.simplify(this.numerator, this.denominator);
    }

    private Fraction simplify(long l, long l2) {
        if (l == Long.MIN_VALUE || l2 == Long.MIN_VALUE) {
            throw new ArithmeticException();
        }
        if (l == 0L) {
            l2 = Long.signum(l2);
        } else if (l2 == 0L) {
            l = Long.signum(l);
        } else if (l2 % l == 0L) {
            if ((l2 /= l) < 0L) {
                l2 = -l2;
                l = -1L;
            } else {
                l = 1L;
            }
        } else {
            long l3;
            long l4 = Math.abs(l);
            long l5 = l4 % (l3 = Math.abs(l2));
            if (l5 == 0L) {
                l /= l2;
                l2 = 1L;
            } else {
                while ((l5 = (l4 = l3) % (l3 = l5)) != 0L) {
                }
                l /= l3;
                if ((l2 /= l3) < 0L) {
                    l = -l;
                    l2 = -l2;
                }
            }
        }
        return l == (long)this.numerator && l2 == (long)this.denominator ? this : new Fraction(Math.toIntExact(l), Math.toIntExact(l2));
    }

    public Fraction negate() {
        int n = this.numerator;
        int n2 = this.denominator;
        if (n != 0) {
            n = Math.negateExact(n);
        } else if (n2 != 0) {
            n2 = Math.negateExact(n2);
        } else {
            return this;
        }
        return new Fraction(n, n2);
    }

    public Fraction add(Fraction fraction) {
        long l = this.denominator;
        long l2 = fraction.denominator;
        return this.simplify(Math.addExact(l2 * (long)this.numerator, l * (long)fraction.numerator), l2 * l);
    }

    public Fraction subtract(Fraction fraction) {
        long l = this.denominator;
        long l2 = fraction.denominator;
        return this.simplify(Math.subtractExact(l2 * (long)this.numerator, l * (long)fraction.numerator), l2 * l);
    }

    public Fraction multiply(Fraction fraction) {
        return this.simplify(Math.multiplyFull(this.numerator, fraction.numerator), Math.multiplyFull(this.denominator, fraction.denominator));
    }

    public Fraction divide(Fraction fraction) {
        return this.simplify(Math.multiplyFull(this.numerator, fraction.denominator), Math.multiplyFull(this.denominator, fraction.numerator));
    }

    public int round() {
        int n;
        if (this.denominator == Integer.MIN_VALUE) {
            if (this.numerator < -1073741824) {
                return 1;
            }
            if (this.numerator > 0x40000000) {
                return -1;
            }
            return 0;
        }
        int n2 = this.numerator / this.denominator;
        int n3 = this.numerator % this.denominator;
        if (n3 != 0 && ((n3 = Math.abs(n3 << 1)) > (n = Math.abs(this.denominator)) || n3 == n && (n2 & 1) != 0)) {
            n2 = (this.numerator ^ this.denominator) >= 0 ? ++n2 : --n2;
        }
        return n2;
    }

    public int floor() {
        int n = this.numerator / this.denominator;
        if ((this.numerator ^ this.denominator) < 0 && this.numerator % this.denominator != 0) {
            --n;
        }
        return n;
    }

    public int ceil() {
        int n = this.numerator / this.denominator;
        if ((this.numerator ^ this.denominator) >= 0 && this.numerator % this.denominator != 0) {
            ++n;
        }
        return n;
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public int intValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public short shortValue() {
        int n = this.intValue();
        if ((n & 0xFFFF0000) == 0) {
            return (short)n;
        }
        throw new ArithmeticException();
    }

    @Override
    public byte byteValue() {
        int n = this.intValue();
        if ((n & 0xFFFFFF00) == 0) {
            return (byte)n;
        }
        throw new ArithmeticException();
    }

    public int signum() {
        if (this.numerator == 0) {
            return 0;
        }
        return (this.numerator ^ this.denominator) >> 30 | 1;
    }

    @Override
    public int compareTo(Fraction fraction) {
        return Long.signum(Math.multiplyFull(this.numerator, fraction.denominator) - Math.multiplyFull(fraction.numerator, this.denominator));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Fraction) {
            Fraction fraction = (Fraction)object;
            return this.numerator == fraction.numerator && this.denominator == fraction.denominator;
        }
        return false;
    }

    public int hashCode() {
        return this.numerator + 31 * this.denominator ^ 0xA9A52E90;
    }

    public String toString() {
        switch (this.denominator) {
            case 0: {
                if (this.numerator == 0) break;
                return this.numerator >= 0 ? "\u221e" : "\u2212\u221e";
            }
            case 1: {
                return String.valueOf(this.numerator);
            }
            default: {
                char c;
                char[] cArray;
                int n;
                if (this.numerator < 0 || this.numerator >= UNICODES.length || (n = this.denominator - this.numerator - 1) < 0 || n >= (cArray = UNICODES[this.numerator]).length || (c = cArray[n]) == '\u0000') break;
                return String.valueOf(c);
            }
        }
        return "" + this.numerator + '\u2044' + this.denominator;
    }

    public Fraction(String string) throws NumberFormatException {
        int n;
        int n2 = string.length();
        if (n2 == 1 && (n = string.charAt(0)) >= 128) {
            for (int i = 0; i < UNICODES.length; ++i) {
                char[] cArray = UNICODES[i];
                for (int j = 0; j < cArray.length; ++j) {
                    if (cArray[j] != n) continue;
                    this.numerator = i;
                    this.denominator = i + j + 1;
                    return;
                }
            }
            if (n == 8734) {
                this.numerator = 1;
                this.denominator = 0;
                return;
            }
        }
        if (string.equals("\u2212\u221e") || string.equals("-\u221e")) {
            this.numerator = -1;
            this.denominator = 0;
            return;
        }
        for (n = 0; n < n2; ++n) {
            switch (string.charAt(n)) {
                case '/': 
                case '\u00f7': 
                case '\u2044': 
                case '\u2215': {
                    this.numerator = Integer.parseInt(string, 0, n, 10);
                    this.denominator = Integer.parseInt(string, n + 1, n2, 10);
                    return;
                }
            }
        }
        this.numerator = Integer.parseInt(string);
        this.denominator = 1;
    }
}

