/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat.math;

import java.util.function.Function;
import tech.uom.seshat.math.Fraction;
import tech.uom.seshat.resources.Errors;

public final class FractionConverter
implements Function<Fraction, Integer> {
    public static final FractionConverter INSTANCE = new FractionConverter();

    private FractionConverter() {
    }

    @Override
    public Integer apply(Fraction fraction) {
        if (fraction.numerator % fraction.denominator == 0) {
            return fraction.numerator / fraction.denominator;
        }
        throw new IllegalArgumentException(Errors.format((short)18, fraction, Integer.class));
    }

    public static final class FromInteger
    implements Function<Integer, Fraction> {
        public static final FromInteger INSTANCE = new FromInteger();

        private FromInteger() {
        }

        @Override
        public Fraction apply(Integer n) {
            return new Fraction(n, 1);
        }
    }
}

