/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat.math;

import java.util.Arrays;
import java.util.Objects;

public final class MathFunctions {
    public static final int SIGNIFICAND_SIZE = 52;
    private static final int SIGNIFICAND_SIZE_OF_FLOAT = 23;
    private static final int EXPONENT_FOR_ZERO = -324;
    private static final int EXPONENT_FOR_MAX = 308;
    public static final int HIGHEST_SUPPORTED_PRIME_NUMBER = 65521;
    private static final int PRIMES_LENGTH_15_BITS = 3512;
    private static final int PRIMES_LENGTH_16_BITS = 6542;
    private static volatile short[] primes = new short[]{2, 3};
    private static final double[] POW10 = new double[632];

    private MathFunctions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int primeNumberAt(int n) throws IndexOutOfBoundsException {
        Objects.checkIndex(n, 6542);
        short[] sArray = primes;
        if (n < sArray.length) return Short.toUnsignedInt(sArray[n]);
        Class<MathFunctions> clazz = MathFunctions.class;
        synchronized (MathFunctions.class) {
            sArray = primes;
            if (n < sArray.length) return Short.toUnsignedInt(sArray[n]);
            int n2 = sArray.length;
            int n3 = Short.toUnsignedInt(sArray[n2 - 1]);
            sArray = Arrays.copyOf(sArray, Math.min((n | 0xF) + 1, 6542));
            block3: while (true) {
                int n4;
                int n5 = (int)Math.sqrt(n3 += 2);
                int n6 = 0;
                do {
                    if (n3 % (n4 = Short.toUnsignedInt(sArray[++n6])) == 0) continue block3;
                } while (n4 <= n5);
                sArray[n2] = (short)n3;
                if (++n2 >= sArray.length) break;
            }
            primes = sArray;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Short.toUnsignedInt(sArray[n]);
        }
    }

    public static int nextPrimeNumber(int n) throws IllegalArgumentException {
        int n2;
        if (n < 2 || n > 65521) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        short[] sArray = primes;
        int n3 = 0;
        int n4 = Math.min(3512, sArray.length);
        if (n > Short.MAX_VALUE) {
            n3 = n4;
            n4 = sArray.length;
        }
        if ((n2 = Arrays.binarySearch(sArray, n3, n4, (short)n)) < 0 && (n2 ^= 0xFFFFFFFF) >= sArray.length) {
            int n5;
            while ((n5 = MathFunctions.primeNumberAt(n2++)) < n) {
            }
            return n5;
        }
        return Short.toUnsignedInt(sArray[n2]);
    }

    public static double pow10(int n) {
        return (n += 323) >= 0 ? (n < POW10.length ? POW10[n] : Double.POSITIVE_INFINITY) : 0.0;
    }

    public static int toExp10(int n) {
        assert (n >= -2620 && n <= 2620) : n;
        return n * 315653 >> 20;
    }

    private static int getSignificand(float f) {
        int n = Float.floatToRawIntBits(f);
        int n2 = n & 0x7F800000;
        n = (int)((long)n & 0x7FFFFFL);
        n = n2 != 0 ? (int)((long)n | 0x800000L) : (n <<= 1);
        return n;
    }

    public static double floatToDouble(float f) {
        int n = Math.getExponent(f) - 23;
        if (n >= 0) {
            return f;
        }
        int n2 = MathFunctions.getSignificand(f);
        assert (Math.scalb(n2, n) == Math.abs(f)) : f;
        int n3 = -MathFunctions.toExp10(n);
        double d = Math.scalb(MathFunctions.pow10(n3), n);
        double d2 = (double)n2 * d;
        double d3 = Math.rint(d2 / 10.0) * 10.0;
        if (Math.abs(d3 - d2) >= d / 2.0) {
            d3 = Math.rint(d2);
        }
        d3 = Math.copySign(Math.scalb(d3 / d, n), (double)f);
        assert (f == (float)d3) : f;
        return d3;
    }

    public static boolean equals(double d, double d2) {
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    static {
        StringBuilder stringBuilder = new StringBuilder("1E");
        for (int i = 0; i < POW10.length; ++i) {
            stringBuilder.setLength(2);
            stringBuilder.append(i + -323);
            MathFunctions.POW10[i] = Double.parseDouble(stringBuilder.toString());
        }
    }
}

