/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat.util;

import java.util.Objects;
import tech.uom.seshat.util.StringBuilders;

public final class CharSequences {
    private CharSequences() {
    }

    private static int length(CharSequence charSequence) {
        return charSequence != null ? charSequence.length() : 0;
    }

    private static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n, int n2) {
        if (charSequence != null) {
            int n3 = charSequence.length();
            if (n2 > n3) {
                n2 = n3;
            }
            if (charSequence2 instanceof String && n2 == n3) {
                if (charSequence instanceof String) {
                    return ((String)charSequence).indexOf((String)charSequence2, n);
                }
                if (charSequence instanceof StringBuilder) {
                    return ((StringBuilder)charSequence).indexOf((String)charSequence2, n);
                }
                if (charSequence instanceof StringBuffer) {
                    return ((StringBuffer)charSequence).indexOf((String)charSequence2, n);
                }
            }
            if (n < 0) {
                n = 0;
            }
            n3 = charSequence2.length();
            n2 -= n3;
            while (n <= n2) {
                block10: {
                    for (int i = 0; i < n3; ++i) {
                        if (charSequence.charAt(n + i) == charSequence2.charAt(i)) {
                            continue;
                        }
                        break block10;
                    }
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public static int skipLeadingWhitespaces(CharSequence charSequence, int n, int n2) {
        int n3;
        while (n < n2 && Character.isWhitespace(n3 = Character.codePointAt(charSequence, n))) {
            n += Character.charCount(n3);
        }
        return n;
    }

    public static int skipTrailingWhitespaces(CharSequence charSequence, int n, int n2) {
        int n3;
        while (n2 > n && Character.isWhitespace(n3 = Character.codePointBefore(charSequence, n2))) {
            n2 -= Character.charCount(n3);
        }
        return n2;
    }

    public static CharSequence toASCII(CharSequence charSequence) {
        return StringBuilders.toASCII(charSequence, null);
    }

    public static CharSequence trimWhitespaces(CharSequence charSequence, int n, int n2) {
        int n3 = CharSequences.length(charSequence);
        Objects.checkFromToIndex(n, n2, n3);
        if (charSequence != null) {
            n = CharSequences.skipLeadingWhitespaces(charSequence, n, n2);
            n2 = CharSequences.skipTrailingWhitespaces(charSequence, n, n2);
            if (n != 0 || n2 != n3) {
                charSequence = charSequence.subSequence(n, n2);
            }
        }
        return charSequence;
    }

    private static boolean equalsIgnoreCase(int n, int n2) {
        if ((n = Character.toUpperCase(n)) == (n2 = Character.toUpperCase(n2))) {
            return true;
        }
        return Character.toLowerCase(n) == Character.toLowerCase(n2);
    }

    public static boolean regionMatches(CharSequence charSequence, int n, CharSequence charSequence2) {
        int n2;
        int n3 = charSequence.length();
        int n4 = charSequence2.length();
        if (n < 0) {
            return false;
        }
        for (int i = 0; i < n4; i += Character.charCount(n2)) {
            int n5;
            if (n >= n3) {
                return false;
            }
            n2 = Character.codePointAt(charSequence2, i);
            if (n2 != (n5 = Character.codePointAt(charSequence, n)) && !CharSequences.equalsIgnoreCase(n2, n5)) {
                return false;
            }
            n += Character.charCount(n5);
        }
        return true;
    }

    public static CharSequence replace(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        if (charSequence != null && !charSequence2.equals(charSequence3)) {
            if (charSequence instanceof String) {
                return ((String)charSequence).replace(charSequence2, charSequence3);
            }
            int n = charSequence.length();
            int n2 = CharSequences.indexOf(charSequence, charSequence2, 0, n);
            if (n2 >= 0) {
                int n3 = 0;
                int n4 = charSequence2.length();
                StringBuilder stringBuilder = new StringBuilder(n + (charSequence3.length() - n4));
                do {
                    stringBuilder.append(charSequence, n3, n2).append(charSequence3);
                } while ((n2 = CharSequences.indexOf(charSequence, charSequence2, n3 = n2 + n4, n)) >= 0);
                return stringBuilder.append(charSequence, n3, n);
            }
        }
        return charSequence;
    }
}

