/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat.util;

import java.text.Normalizer;

public final class StringBuilders {
    private static final String ASCII = "AAAAAA\u00c6CEEEEIIIIDNOOOOO*OUUUUY\u00desaaaaaa\u00e6ceeeeiiiionooooo/ouuuuy\u00fey";

    private StringBuilders() {
    }

    public static void trimFractionalPart(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        block4: while (n > 0) {
            switch (stringBuilder.charAt(--n)) {
                case '0': {
                    continue block4;
                }
                case '.': {
                    stringBuilder.setLength(n);
                }
            }
            return;
        }
    }

    static CharSequence toASCII(CharSequence charSequence, StringBuilder stringBuilder) {
        if (charSequence != null) {
            boolean bl = false;
            int n = charSequence.length();
            block14: while (n > 0) {
                char c;
                int n2 = Character.codePointBefore(charSequence, n);
                int n3 = Character.charCount(n2);
                int n4 = n2 - 192;
                n -= n3;
                if (n4 < 0) continue;
                if (n4 < ASCII.length()) {
                    c = ASCII.charAt(n4);
                } else {
                    block0 : switch (Character.getType(n2)) {
                        case 6: 
                        case 15: 
                        case 16: {
                            c = '\u0000';
                            break;
                        }
                        case 13: 
                        case 14: {
                            c = '\n';
                            break;
                        }
                        case 12: {
                            c = ' ';
                            break;
                        }
                        case 29: {
                            c = n2 == 8216 ? (char)'\'' : '\"';
                            break;
                        }
                        case 30: {
                            c = n2 == 8217 ? (char)'\'' : '\"';
                            break;
                        }
                        case 24: 
                        case 25: {
                            switch (n2) {
                                case 8901: {
                                    c = '*';
                                    break block0;
                                }
                                case 8725: {
                                    c = '/';
                                    break block0;
                                }
                                case 8242: {
                                    c = '\'';
                                    break block0;
                                }
                                case 8243: {
                                    c = '\"';
                                    break block0;
                                }
                            }
                            continue block14;
                        }
                        default: {
                            if (bl) continue block14;
                            bl = true;
                            String string = Normalizer.normalize(charSequence, Normalizer.Form.NFKD);
                            if (string.contentEquals(charSequence)) continue block14;
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder(string.length());
                                charSequence = stringBuilder;
                            } else {
                                stringBuilder.setLength(0);
                            }
                            n = stringBuilder.append(string).length();
                            continue block14;
                        }
                    }
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(charSequence.length()).append(charSequence);
                    charSequence = stringBuilder;
                }
                if (c == '\u0000') {
                    stringBuilder.delete(n, n + n3);
                    continue;
                }
                if (n3 == 2) {
                    stringBuilder.deleteCharAt(n + 1);
                }
                stringBuilder.setCharAt(n, c);
            }
        }
        return charSequence;
    }
}

