/*
 * Decompiled with CFR 0.152.
 */
package tech.uom.seshat.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import tech.uom.seshat.util.WeakEntry;

public class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private Entry[] table;
    private int count;
    private final Class<K> keyType;
    private transient Set<Map.Entry<K, V>> entrySet;
    private transient long lastTimeNormalCapacity;

    public WeakValueHashMap(Class<K> clazz) {
        this.keyType = clazz;
        this.lastTimeNormalCapacity = System.nanoTime();
        this.table = new Entry[7];
    }

    private synchronized void removeEntry(Entry entry) {
        assert (this.isValid());
        int n = this.table.length;
        if (entry.removeFrom(this.table, entry.hash % n)) {
            long l;
            --this.count;
            assert (this.isValid());
            if (this.count < WeakEntry.lowerCapacityThreshold(n) && (l = System.nanoTime()) - this.lastTimeNormalCapacity > 4000000000L) {
                this.table = (Entry[])WeakEntry.rehash(this.table, this.count);
                this.lastTimeNormalCapacity = l;
                assert (this.isValid());
            }
        }
    }

    final boolean isValid() {
        if (!Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.count > WeakEntry.upperCapacityThreshold(this.table.length)) {
            throw new AssertionError(this.count);
        }
        return WeakEntry.count(this.table) == this.count;
    }

    @Override
    public synchronized int size() {
        assert (this.isValid());
        return this.count;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public synchronized boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public synchronized V get(Object object) {
        assert (this.isValid());
        if (object != null) {
            Entry[] entryArray = this.table;
            int n = (object.hashCode() & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n];
            while (entry != null) {
                if (object.equals(entry.key)) {
                    return (V)entry.get();
                }
                entry = (Entry)entry.next;
            }
        }
        return null;
    }

    private synchronized V intern(Object object, V v, Object object2) {
        assert (this.isValid());
        V v2 = null;
        Entry[] entryArray = this.table;
        int n = object.hashCode() & Integer.MAX_VALUE;
        int n2 = n % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (object.equals(entry.key)) {
                v2 = (V)entry.get();
                if (object2 != null && !object2.equals(v2)) {
                    return v2;
                }
                entry.dispose();
                entryArray = this.table;
                n2 = n % entryArray.length;
            }
            entry = (Entry)entry.next;
        }
        if (v != null && (object2 == null || object2 == Wildcard.NO_VALUE || v2 != null)) {
            if (++this.count >= WeakEntry.lowerCapacityThreshold(entryArray.length)) {
                if (this.count > WeakEntry.upperCapacityThreshold(entryArray.length)) {
                    this.table = entryArray = (Entry[])WeakEntry.rehash(entryArray, this.count);
                    n2 = n % entryArray.length;
                }
                this.lastTimeNormalCapacity = System.nanoTime();
            }
            entryArray[n2] = new Entry(this.keyType.cast(object), v, entryArray[n2], n);
        }
        assert (this.isValid());
        return v2;
    }

    @Override
    public V put(K k, V v) {
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        return this.intern(k, v, null);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        return this.intern(k, v, Wildcard.NO_VALUE);
    }

    @Override
    public V replace(K k, V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (k == null) {
            return null;
        }
        return this.intern(k, v, Wildcard.ANY_VALUE);
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        return this.replaceOrRemove(k, v, v2);
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        return this.intern(object, null, null);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.replaceOrRemove(object, object2, null);
    }

    private boolean replaceOrRemove(Object object, final Object object2, V v) {
        if (object == null || object2 == null) {
            return false;
        }
        final class Observer {
            boolean equals;

            Observer() {
            }

            public boolean equals(Object object) {
                this.equals = object2.equals(object);
                return this.equals;
            }
        }
        Observer observer = new Observer();
        return this.intern(object, v, observer) != null && observer.equals;
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private final class Entry
    extends WeakEntry<V>
    implements Map.Entry<K, V> {
        final K key;

        Entry(K k, V v, Entry entry, int n) {
            super(v, entry, n);
            this.key = k;
            this.next = entry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.get();
        }

        @Override
        public V setValue(V v) {
            if (v != null) {
                throw new UnsupportedOperationException();
            }
            Object t = this.get();
            this.dispose();
            return t;
        }

        @Override
        public void dispose() {
            super.clear();
            WeakValueHashMap.this.removeEntry(this);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.key.equals(entry.getKey()) && Objects.equals(this.get(), entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            int n = this.key.hashCode();
            Object t = this.get();
            if (t != null) {
                n ^= t.hashCode();
            }
            return n;
        }
    }

    private static final class Wildcard {
        static final Wildcard ANY_VALUE = new Wildcard(true);
        static final Wildcard NO_VALUE = new Wildcard(false);
        private final boolean present;

        private Wildcard(boolean bl) {
            this.present = bl;
        }

        public boolean equals(Object object) {
            return object != null == this.present;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return WeakValueHashMap.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map.Entry<K, V>[] toArray() {
            WeakValueHashMap weakValueHashMap = WeakValueHashMap.this;
            synchronized (weakValueHashMap) {
                Entry[] entryArray;
                assert (WeakValueHashMap.this.isValid());
                Map.Entry[] entryArray2 = new Map.Entry[this.size()];
                int n = 0;
                for (Entry entry : entryArray = WeakValueHashMap.this.table) {
                    while (entry != null) {
                        AbstractMap.SimpleEntry simpleEntry = new AbstractMap.SimpleEntry(entry);
                        if (simpleEntry.getValue() != null) {
                            entryArray2[n++] = simpleEntry;
                        }
                        entry = (Entry)entry.next;
                    }
                }
                if (n != entryArray2.length) {
                    entryArray2 = Arrays.copyOf(entryArray2, n);
                }
                return entryArray2;
            }
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Arrays.asList(this.toArray()).iterator();
        }
    }
}

