/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.common;

import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.ValueReader;
import tech.ydb.table.values.DecimalValue;
import tech.ydb.table.values.PrimitiveType;
import tech.ydb.table.values.PrimitiveValue;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public class FixedResultSetFactory {
    private final List<Column> columns;
    private final Map<String, Integer> columnIndexes;

    private FixedResultSetFactory(List<Column> columns) {
        this.columns = columns;
        this.columnIndexes = new HashMap<String, Integer>();
        for (int idx = 0; idx < columns.size(); ++idx) {
            this.columnIndexes.put(columns.get(idx).name, idx);
        }
    }

    public ResultSetBuilder createResultSet() {
        return new ResultSetBuilderImpl();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class FixedValueReader
    implements ValueReader {
        private final PrimitiveValue value;
        private final Type type;

        FixedValueReader(PrimitiveValue value, Type type) {
            this.value = value;
            this.type = type;
        }

        public boolean getBool() {
            return this.value.getBool();
        }

        public byte getInt8() {
            return this.value.getInt8();
        }

        public int getUint8() {
            return this.value.getUint8();
        }

        public short getInt16() {
            return this.value.getInt16();
        }

        public int getUint16() {
            return this.value.getUint16();
        }

        public int getInt32() {
            return this.value.getInt32();
        }

        public long getUint32() {
            return this.value.getUint32();
        }

        public long getInt64() {
            return this.value.getInt64();
        }

        public long getUint64() {
            return this.value.getUint64();
        }

        public float getFloat() {
            return this.value.getFloat();
        }

        public double getDouble() {
            return this.value.getDouble();
        }

        public LocalDate getDate() {
            return this.value.getDate();
        }

        public LocalDateTime getDatetime() {
            return this.value.getDatetime();
        }

        public Instant getTimestamp() {
            return this.value.getTimestamp();
        }

        public Duration getInterval() {
            return this.value.getInterval();
        }

        public ZonedDateTime getTzDate() {
            return this.value.getTzDate();
        }

        public ZonedDateTime getTzDatetime() {
            return this.value.getTzDatetime();
        }

        public ZonedDateTime getTzTimestamp() {
            return this.value.getTzTimestamp();
        }

        public byte[] getBytes() {
            return this.value.getBytes();
        }

        public String getBytesAsString(Charset charset) {
            return this.value.getBytesAsString(charset);
        }

        public UUID getUuid() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getText() {
            return this.value.getText();
        }

        public byte[] getYson() {
            return this.value.getYson();
        }

        public String getJson() {
            return this.value.getJson();
        }

        public String getJsonDocument() {
            return this.value.getJsonDocument();
        }

        public DecimalValue getDecimal() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void toString(StringBuilder sb) {
            sb.append(this.value.toString());
        }

        public Value<?> getValue() {
            return this.value;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isOptionalItemPresent() {
            return this.value != null;
        }

        public ValueReader getOptionalItem() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getTupleElementsCount() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ValueReader getTupleElement(int index) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getListItemsCount() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ValueReader getListItem(int index) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getDictItemsCount() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ValueReader getDictKey(int index) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ValueReader getDictValue(int index) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getStructMembersCount() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getStructMemberName(int index) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ValueReader getStructMember(int index) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ValueReader getStructMember(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getVariantTypeIndex() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ValueReader getVariantItem() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class Builder {
        private final List<Column> columns = new ArrayList<Column>();

        public Builder addTextColumn(String name) {
            this.columns.add(new Column(name, (Type)PrimitiveType.Text.makeOptional()));
            return this;
        }

        public Builder addIntColumn(String name) {
            this.columns.add(new Column(name, (Type)PrimitiveType.Int32.makeOptional()));
            return this;
        }

        public Builder addShortColumn(String name) {
            this.columns.add(new Column(name, (Type)PrimitiveType.Int16.makeOptional()));
            return this;
        }

        public Builder addLongColumn(String name) {
            this.columns.add(new Column(name, (Type)PrimitiveType.Int64.makeOptional()));
            return this;
        }

        public Builder addBooleanColumn(String name) {
            this.columns.add(new Column(name, (Type)PrimitiveType.Bool.makeOptional()));
            return this;
        }

        public FixedResultSetFactory build() {
            return new FixedResultSetFactory(this.columns);
        }
    }

    private static class Column {
        private final String name;
        private final Type type;

        Column(String name, Type type) {
            this.name = name;
            this.type = type;
        }
    }

    private class FixedResultSet
    implements ResultSetReader {
        private final List<Map<Column, ValueReader>> rows;
        private int rowIndex = 0;

        FixedResultSet(List<Map<Column, ValueReader>> rows) {
            this.rows = rows;
        }

        public boolean isTruncated() {
            return false;
        }

        public int getColumnCount() {
            return FixedResultSetFactory.this.columns.size();
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public void setRowIndex(int index) {
            this.rowIndex = index;
        }

        public boolean next() {
            if (this.rowIndex >= this.rows.size()) {
                return false;
            }
            ++this.rowIndex;
            return true;
        }

        public String getColumnName(int index) {
            return ((Column)FixedResultSetFactory.this.columns.get(index)).name;
        }

        public int getColumnIndex(String name) {
            return (Integer)FixedResultSetFactory.this.columnIndexes.get(name);
        }

        public ValueReader getColumn(int index) {
            return this.rows.get(this.rowIndex).get(FixedResultSetFactory.this.columns.get(index));
        }

        public ValueReader getColumn(String name) {
            return this.rows.get(this.rowIndex).get(FixedResultSetFactory.this.columns.get((Integer)FixedResultSetFactory.this.columnIndexes.get(name)));
        }

        public Type getColumnType(int index) {
            return ((Column)FixedResultSetFactory.this.columns.get(index)).type;
        }
    }

    private class ResultSetBuilderImpl
    implements ResultSetBuilder {
        private final List<Map<Column, ValueReader>> rows = new ArrayList<Map<Column, ValueReader>>();

        private ResultSetBuilderImpl() {
        }

        @Override
        public ResultSetBuilder.RowBuilder newRow() {
            return new RowImpl();
        }

        @Override
        public ResultSetReader build() {
            return new FixedResultSet(this.rows);
        }

        private class RowImpl
        implements ResultSetBuilder.RowBuilder {
            private final Map<Column, ValueReader> values = new HashMap<Column, ValueReader>();

            private RowImpl() {
            }

            @Override
            public ResultSetBuilder.RowBuilder withTextValue(String name, String value) {
                Column column = (Column)FixedResultSetFactory.this.columns.get((Integer)FixedResultSetFactory.this.columnIndexes.get(name));
                if (value != null) {
                    this.values.put(column, new FixedValueReader(PrimitiveValue.newText((String)value), column.type));
                }
                return this;
            }

            @Override
            public ResultSetBuilder.RowBuilder withIntValue(String name, int value) {
                Column column = (Column)FixedResultSetFactory.this.columns.get((Integer)FixedResultSetFactory.this.columnIndexes.get(name));
                this.values.put(column, new FixedValueReader(PrimitiveValue.newInt32((int)value), column.type));
                return this;
            }

            @Override
            public ResultSetBuilder.RowBuilder withShortValue(String name, short value) {
                Column column = (Column)FixedResultSetFactory.this.columns.get((Integer)FixedResultSetFactory.this.columnIndexes.get(name));
                this.values.put(column, new FixedValueReader(PrimitiveValue.newInt16((short)value), column.type));
                return this;
            }

            @Override
            public ResultSetBuilder.RowBuilder withLongValue(String name, long value) {
                Column column = (Column)FixedResultSetFactory.this.columns.get((Integer)FixedResultSetFactory.this.columnIndexes.get(name));
                this.values.put(column, new FixedValueReader(PrimitiveValue.newInt64((long)value), column.type));
                return this;
            }

            @Override
            public ResultSetBuilder.RowBuilder withBoolValue(String name, boolean value) {
                Column column = (Column)FixedResultSetFactory.this.columns.get((Integer)FixedResultSetFactory.this.columnIndexes.get(name));
                this.values.put(column, new FixedValueReader(PrimitiveValue.newBool((boolean)value), column.type));
                return this;
            }

            @Override
            public ResultSetBuilder build() {
                for (Column column : FixedResultSetFactory.this.columns) {
                    if (this.values.containsKey(column)) continue;
                    this.values.put(column, new FixedValueReader(null, column.type));
                }
                ResultSetBuilderImpl.this.rows.add(this.values);
                return ResultSetBuilderImpl.this;
            }
        }
    }

    public static interface ResultSetBuilder {
        public RowBuilder newRow();

        public ResultSetReader build();

        public static interface RowBuilder {
            public RowBuilder withTextValue(String var1, String var2);

            public RowBuilder withIntValue(String var1, int var2);

            public RowBuilder withShortValue(String var1, short var2);

            public RowBuilder withLongValue(String var1, long var2);

            public RowBuilder withBoolValue(String var1, boolean var2);

            public ResultSetBuilder build();
        }
    }
}

