/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.context;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import tech.ydb.common.transaction.TxMode;
import tech.ydb.core.Result;
import tech.ydb.core.UnexpectedResultException;
import tech.ydb.jdbc.context.BaseYdbExecutor;
import tech.ydb.jdbc.context.YdbContext;
import tech.ydb.jdbc.context.YdbValidator;
import tech.ydb.jdbc.exception.ExceptionFactory;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.query.QueryClient;
import tech.ydb.query.QuerySession;
import tech.ydb.query.QueryStream;
import tech.ydb.query.QueryTransaction;
import tech.ydb.query.settings.CommitTransactionSettings;
import tech.ydb.query.settings.ExecuteQuerySettings;
import tech.ydb.query.settings.RollbackTransactionSettings;
import tech.ydb.query.tools.QueryReader;
import tech.ydb.table.query.Params;
import tech.ydb.table.result.ResultSetReader;

public class QueryServiceExecutor
extends BaseYdbExecutor {
    private final Duration sessionTimeout;
    private final QueryClient queryClient;
    private int transactionLevel;
    private boolean isReadOnly;
    private boolean isAutoCommit;
    private TxMode txMode;
    private QueryTransaction tx;
    private boolean isClosed;

    public QueryServiceExecutor(YdbContext ctx, int transactionLevel, boolean autoCommit) throws SQLException {
        super(ctx);
        this.sessionTimeout = ctx.getOperationProperties().getSessionTimeout();
        this.queryClient = ctx.getQueryClient();
        this.transactionLevel = transactionLevel;
        this.isReadOnly = transactionLevel != 8;
        this.isAutoCommit = autoCommit;
        this.txMode = QueryServiceExecutor.txMode(transactionLevel, this.isReadOnly);
        this.tx = null;
        this.isClosed = false;
    }

    protected QuerySession createNewQuerySession(YdbValidator validator) throws SQLException {
        try {
            Result session = (Result)this.queryClient.createSession(this.sessionTimeout).join();
            validator.addStatusIssues(session.getStatus());
            return (QuerySession)session.getValue();
        }
        catch (UnexpectedResultException ex) {
            throw ExceptionFactory.createException("Cannot create session with " + ex.getStatus(), ex);
        }
    }

    @Override
    public void close() {
        this.cleanTx();
        this.isClosed = true;
    }

    private void cleanTx() {
        if (this.tx != null) {
            this.tx.getSession().close();
            this.tx = null;
        }
    }

    @Override
    public void setTransactionLevel(int level) throws SQLException {
        if (level == this.transactionLevel) {
            return;
        }
        if (this.tx != null && this.tx.isActive()) {
            throw new SQLFeatureNotSupportedException("Cannot change transaction isolation inside a transaction");
        }
        this.isReadOnly = this.isReadOnly || level != 8;
        this.transactionLevel = level;
        this.txMode = QueryServiceExecutor.txMode(this.transactionLevel, this.isReadOnly);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly == this.isReadOnly) {
            return;
        }
        if (this.tx != null && this.tx.isActive()) {
            throw new SQLFeatureNotSupportedException("Cannot change read-only attribute inside a transaction");
        }
        this.isReadOnly = readOnly;
        this.txMode = QueryServiceExecutor.txMode(this.transactionLevel, this.isReadOnly);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit == this.isAutoCommit) {
            return;
        }
        if (this.tx != null && this.tx.isActive()) {
            throw new SQLFeatureNotSupportedException("Cannot change transaction isolation inside a transaction");
        }
        this.isAutoCommit = autoCommit;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public String txID() {
        return this.tx != null ? this.tx.getId() : null;
    }

    @Override
    public boolean isInsideTransaction() throws SQLException {
        this.ensureOpened();
        return this.tx != null && this.tx.isActive();
    }

    @Override
    public boolean isAutoCommit() throws SQLException {
        this.ensureOpened();
        return this.isAutoCommit;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureOpened();
        return this.isReadOnly;
    }

    @Override
    public int transactionLevel() throws SQLException {
        this.ensureOpened();
        return this.transactionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(YdbContext ctx, YdbValidator validator) throws SQLException {
        this.ensureOpened();
        if (this.tx == null || !this.tx.isActive()) {
            return;
        }
        CommitTransactionSettings settings = ctx.withRequestTimeout(CommitTransactionSettings.newBuilder()).build();
        try {
            validator.clearWarnings();
            validator.call("Commit TxId: " + this.tx.getId(), () -> this.tx.commit(settings));
        }
        finally {
            this.cleanTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(YdbContext ctx, YdbValidator validator) throws SQLException {
        this.ensureOpened();
        if (this.tx == null || !this.tx.isActive()) {
            return;
        }
        RollbackTransactionSettings settings = ctx.withRequestTimeout(RollbackTransactionSettings.newBuilder()).build();
        try {
            validator.clearWarnings();
            validator.execute("Rollback TxId: " + this.tx.getId(), () -> this.tx.rollback(settings));
        }
        finally {
            this.cleanTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResultSetReader> executeDataQuery(YdbContext ctx, YdbValidator validator, YdbQuery query, long timeout, boolean keepInCache, Params params) throws SQLException {
        this.ensureOpened();
        String yql = query.getYqlQuery(params);
        ExecuteQuerySettings.Builder builder = ExecuteQuerySettings.newBuilder();
        if (timeout > 0L) {
            builder = (ExecuteQuerySettings.Builder)builder.withRequestTimeout(timeout, TimeUnit.SECONDS);
        }
        ExecuteQuerySettings settings = builder.build();
        if (this.tx == null) {
            this.tx = this.createNewQuerySession(validator).createNewTransaction(this.txMode);
        }
        try {
            QueryReader result = (QueryReader)validator.call((Object)((Object)QueryType.DATA_QUERY) + " >>\n" + yql, () -> QueryReader.readFrom((QueryStream)this.tx.createQuery(yql, this.isAutoCommit, params, settings)));
            ArrayList<ResultSetReader> readers = new ArrayList<ResultSetReader>();
            result.forEach(readers::add);
            ArrayList<ResultSetReader> arrayList = readers;
            return arrayList;
        }
        finally {
            if (!this.tx.isActive()) {
                this.cleanTx();
            }
        }
    }

    @Override
    public void executeSchemeQuery(YdbContext ctx, YdbValidator validator, YdbQuery query) throws SQLException {
        ExecuteQuerySettings settings = ctx.withRequestTimeout(ExecuteQuerySettings.newBuilder()).build();
        String yql = query.getYqlQuery(null);
        try (QuerySession session = this.createNewQuerySession(validator);){
            validator.call((Object)((Object)QueryType.SCHEME_QUERY) + " >>\n" + yql, () -> session.createQuery(yql, TxMode.NONE, Params.empty(), settings).execute());
        }
    }

    @Override
    public boolean isValid(YdbValidator validator, int timeout) throws SQLException {
        this.ensureOpened();
        return true;
    }

    private static TxMode txMode(int level, boolean isReadOnly) throws SQLException {
        if (!isReadOnly) {
            if (level != 8) {
                throw new SQLException("Unsupported transaction level: " + level);
            }
            return TxMode.SERIALIZABLE_RW;
        }
        switch (level) {
            case 8: {
                return TxMode.SNAPSHOT_RO;
            }
            case 16: {
                return TxMode.ONLINE_RO;
            }
            case 17: {
                return TxMode.ONLINE_INCONSISTENT_RO;
            }
            case 32: {
                return TxMode.STALE_RO;
            }
        }
        throw new SQLException("Unsupported transaction level: " + level);
    }
}

