/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import tech.ydb.jdbc.YdbConnection;
import tech.ydb.jdbc.YdbParameterMetaData;
import tech.ydb.jdbc.YdbPreparedStatement;
import tech.ydb.jdbc.YdbResultSet;
import tech.ydb.jdbc.YdbTypes;
import tech.ydb.jdbc.common.MappingSetters;
import tech.ydb.jdbc.impl.BaseYdbStatement;
import tech.ydb.jdbc.impl.YdbParameterMetaDataImpl;
import tech.ydb.jdbc.query.JdbcParams;
import tech.ydb.jdbc.query.YdbQuery;
import tech.ydb.table.query.Params;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.VoidType;

public class YdbPreparedStatementImpl
extends BaseYdbStatement
implements YdbPreparedStatement {
    private static final Logger LOGGER = Logger.getLogger(YdbPreparedStatementImpl.class.getName());
    private final YdbQuery query;
    private final JdbcParams params;
    private final YdbTypes types;

    public YdbPreparedStatementImpl(YdbConnection connection, YdbQuery query, JdbcParams params, int resultSetType) {
        super(LOGGER, connection, resultSetType, true);
        this.query = Objects.requireNonNull(query);
        this.params = Objects.requireNonNull(params);
        this.types = connection.getYdbTypes();
    }

    @Override
    public String getQuery() {
        return this.query.originSQL();
    }

    @Override
    public void addBatch() throws SQLException {
        this.params.addBatch();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.params.clearBatch();
    }

    @Override
    public void clearParameters() {
        this.params.clearParameters();
    }

    @Override
    public YdbParameterMetaData getParameterMetaData() {
        return new YdbParameterMetaDataImpl(this.params);
    }

    @Override
    public void close() {
        this.clearParameters();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.cleanState();
        int[] results = new int[this.params.batchSize()];
        if (results.length == 0) {
            return results;
        }
        try {
            for (Params prm : this.params.getBatchParams()) {
                this.executeDataQuery(this.query, prm);
            }
        }
        finally {
            this.clearBatch();
        }
        Arrays.fill(results, -2);
        return results;
    }

    @Override
    public YdbResultSet executeQuery() throws SQLException {
        if (!this.execute()) {
            throw new SQLException("Query must return ResultSet");
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.execute()) {
            throw new SQLException("Query must not return ResultSet");
        }
        return this.getUpdateCount();
    }

    @Override
    public boolean execute() throws SQLException {
        this.cleanState();
        this.clearBatch();
        List<BaseYdbStatement.YdbResult> newState = null;
        switch (this.query.type()) {
            case DATA_QUERY: {
                newState = this.executeDataQuery(this.query, this.params.getCurrentParams());
                break;
            }
            case SCAN_QUERY: {
                newState = this.executeScanQuery(this.query, this.params.getCurrentParams());
                break;
            }
            default: {
                throw new IllegalStateException("Internal error. Unsupported query type " + (Object)((Object)this.query.type()));
            }
        }
        this.params.clearParameters();
        return this.updateState(newState);
    }

    @Override
    public YdbResultSet executeScanQuery() throws SQLException {
        this.cleanState();
        List<BaseYdbStatement.YdbResult> state = this.executeScanQuery(this.query, this.params.getCurrentParams());
        this.params.clearParameters();
        this.updateState(state);
        return this.getResultSet();
    }

    @Override
    public YdbResultSet executeExplainQuery() throws SQLException {
        this.cleanState();
        List<BaseYdbStatement.YdbResult> state = this.executeExplainQuery(this.query);
        this.updateState(state);
        return this.getResultSet();
    }

    private Type ydbType(int sqlType) {
        return this.types.toYdbType(sqlType);
    }

    private Type ydbType(Class<?> clazz) {
        return this.types.toYdbType(clazz);
    }

    private void setImplReader(String name, Reader reader, long length) throws SQLException {
        this.params.setParam(name, (Object)MappingSetters.CharStream.fromReader(reader, length), this.ydbType(12));
    }

    private void setImplStream(String name, InputStream stream, long length) throws SQLException {
        this.params.setParam(name, (Object)MappingSetters.ByteStream.fromInputStream(stream, length), this.ydbType(-2));
    }

    private void setImplReader(int index, Reader reader, long length) throws SQLException {
        this.params.setParam(index, (Object)MappingSetters.CharStream.fromReader(reader, length), this.ydbType(12));
    }

    private void setImplStream(int index, InputStream stream, long length) throws SQLException {
        this.params.setParam(index, (Object)MappingSetters.ByteStream.fromInputStream(stream, length), this.ydbType(-2));
    }

    @Override
    public void setObject(String parameterName, Object value, Type type) throws SQLException {
        this.params.setParam(parameterName, value, type);
    }

    @Override
    public void setObject(int parameterIndex, Object value, Type type) throws SQLException {
        this.params.setParam(parameterIndex, value, type);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        if (x == null) {
            throw new SQLDataException("Unable to set null object, type is required");
        }
        this.params.setParam(parameterName, x, this.ydbType(x.getClass()));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            throw new SQLDataException("Unable to set null object, type is required");
        }
        this.params.setParam(parameterIndex, x, this.ydbType(x.getClass()));
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        Type type = this.ydbType(sqlType);
        if (type == null) {
            type = VoidType.of();
        }
        this.params.setParam(parameterName, null, type);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(Boolean.class));
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(Byte.class));
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(Short.class));
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(Integer.class));
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(Long.class));
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.params.setParam(parameterName, (Object)Float.valueOf(x), this.ydbType(Float.class));
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(Double.class));
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(3));
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(12));
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(-2));
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(91));
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(92));
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(93));
    }

    @Override
    public void setUnicodeStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setImplStream(parameterName, x, (long)length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setImplStream(parameterName, x, (long)length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.params.setParam(parameterName, x, this.ydbType(targetSqlType));
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setImplReader(parameterName, reader, (long)length);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(91));
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(92));
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(93));
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        Type type = this.types.toYdbType(typeName);
        if (type == null) {
            type = this.types.toYdbType(sqlType);
        }
        if (type == null) {
            type = VoidType.of();
        }
        this.params.setParam(parameterName, null, type);
    }

    @Override
    public void setURL(String parameterName, URL x) throws SQLException {
        this.params.setParam(parameterName, (Object)x, this.ydbType(12));
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.params.setParam(parameterName, (Object)value, this.ydbType(12));
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setImplReader(parameterName, value, length);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setImplReader(parameterName, reader, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setImplStream(parameterName, inputStream, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setImplReader(parameterName, reader, length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.params.setParam(parameterName, x, this.ydbType(targetSqlType));
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setImplStream(parameterName, x, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setImplReader(parameterName, reader, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.setImplStream(parameterName, x, -1L);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setImplReader(parameterName, reader, -1L);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setImplReader(parameterName, value, -1L);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setImplReader(parameterName, reader, -1L);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setImplStream(parameterName, inputStream, -1L);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setImplReader(parameterName, reader, -1L);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        Type type = this.ydbType(sqlType);
        if (type == null) {
            type = VoidType.of();
        }
        this.params.setParam(parameterIndex, null, type);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(Boolean.class));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(Byte.class));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(Short.class));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(Integer.class));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(Long.class));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)Float.valueOf(x), this.ydbType(Float.class));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(Double.class));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(3));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(12));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(-2));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(91));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(92));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(93));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setImplStream(parameterIndex, x, (long)length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setImplStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setImplStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.params.setParam(parameterIndex, x, this.ydbType(targetSqlType));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setImplReader(parameterIndex, reader, (long)length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Refs are not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Blobs are not supported");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Clobs are not supported");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(91));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(92));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(93));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        Type type = this.types.toYdbType(typeName);
        if (type == null) {
            type = this.types.toYdbType(sqlType);
        }
        if (type == null) {
            type = VoidType.of();
        }
        this.params.setParam(parameterIndex, null, type);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.params.setParam(parameterIndex, (Object)x, this.ydbType(12));
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.params.setParam(parameterIndex, (Object)value, this.ydbType(12));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setImplReader(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("NClobs are not supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setImplReader(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setImplStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setImplReader(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXMLs are not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.params.setParam(parameterIndex, x, this.ydbType(targetSqlType));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setImplStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setImplStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setImplReader(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setImplStream(parameterIndex, x, -1L);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setImplStream(parameterIndex, x, -1L);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setImplReader(parameterIndex, reader, -1L);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setImplReader(parameterIndex, value, -1L);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setImplReader(parameterIndex, reader, -1L);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setImplStream(parameterIndex, inputStream, -1L);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setImplReader(parameterIndex, reader, -1L);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("ResultSet metadata is not supported in prepared statements");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("RowIds are not supported");
    }

    @Override
    public void executeSchemeQuery(String sql) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public YdbResultSet executeScanQuery(String sql) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public YdbResultSet executeExplainQuery(String sql) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public YdbResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("PreparedStatement cannot execute custom SQL");
    }

    @Override
    public void setArray(String parameterName, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("AsciiStreams are not supported");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("AsciiStreams are not supported");
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("AsciiStreams are not supported");
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Blobs are not supported");
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Clobs are not supported");
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("NClobs are not supported");
    }

    @Override
    public void setRef(String parameterName, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Refs are not supported");
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXMLs are not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }
}

