/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.LongFunction;
import tech.ydb.jdbc.YdbResultSet;
import tech.ydb.jdbc.YdbResultSetMetaData;
import tech.ydb.jdbc.YdbStatement;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.jdbc.impl.YdbResultSetMetaDataImpl;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.ValueReader;
import tech.ydb.table.values.OptionalValue;
import tech.ydb.table.values.Value;

public class YdbResultSetImpl
implements YdbResultSet {
    private final MutableState state = new MutableState();
    private final YdbStatement statement;
    private final ResultSetReader result;
    private final YdbResultSetMetaDataImpl metaData;
    private final int rowCount;

    public YdbResultSetImpl(YdbStatement statement, ResultSetReader result) {
        this.statement = Objects.requireNonNull(statement);
        this.result = Objects.requireNonNull(result);
        this.rowCount = result.getRowCount();
        this.metaData = new YdbResultSetMetaDataImpl(result);
    }

    @Override
    public boolean next() {
        this.setRowIndex(this.state.rowIndex + 1);
        return this.isRowIndexValid();
    }

    @Override
    public void close() {
        this.state.closed = true;
    }

    @Override
    public boolean wasNull() {
        return this.state.nullValue;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        if (this.state.nullValue) {
            return null;
        }
        return this.state.description.getters().readString(this.state.value);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        return this.state.description.getters().readBoolean(this.state.value);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        return this.state.description.getters().readByte(this.state.value);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        return this.state.description.getters().readShort(this.state.value);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        return this.state.description.getters().readInt(this.state.value);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        return this.state.description.getters().readLong(this.state.value);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        return this.state.description.getters().readFloat(this.state.value);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        return this.state.description.getters().readDouble(this.state.value);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(columnIndex);
        if (bigDecimal != null) {
            return bigDecimal.setScale(scale, RoundingMode.HALF_EVEN);
        }
        return null;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        byte[] copy = this.state.description.getters().readBytes(this.state.value);
        if (this.state.nullValue) {
            return null;
        }
        return copy;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDateImpl(columnIndex, Date::new);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getDateImpl(columnIndex, Time::new);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getDateImpl(columnIndex, Timestamp::new);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] bytes = this.getBytes(columnIndex);
        return bytes == null ? null : new ByteArrayInputStream(bytes);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.getColumnIndex(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.getColumnIndex(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.getColumnIndex(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.getColumnIndex(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.getColumnIndex(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.getColumnIndex(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.getColumnIndex(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.getColumnIndex(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.getColumnIndex(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.getColumnIndex(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.getColumnIndex(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(columnLabel));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public YdbResultSetMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        if (this.state.nullValue) {
            return null;
        }
        return this.state.description.getters().readObject(this.state.value);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.getColumnIndex(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.getColumnIndex(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        Reader copy = this.state.description.getters().readReader(this.state.value);
        if (this.state.nullValue) {
            return null;
        }
        return copy;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        BigDecimal copy = this.state.description.getters().readBigDecimal(this.state.value);
        if (this.state.nullValue) {
            return null;
        }
        return copy;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() {
        return this.rowCount != 0 && this.state.rowIndex <= 0;
    }

    @Override
    public boolean isAfterLast() {
        return this.rowCount != 0 && this.state.rowIndex > this.rowCount;
    }

    @Override
    public boolean isFirst() {
        return this.rowCount != 0 && this.state.rowIndex == 1;
    }

    @Override
    public boolean isLast() {
        return this.rowCount != 0 && this.state.rowIndex == this.rowCount;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkScroll();
        this.setRowIndex(0);
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkScroll();
        this.setRowIndex(this.rowCount + 1);
    }

    @Override
    public boolean first() throws SQLException {
        this.checkScroll();
        this.setRowIndex(1);
        return this.isRowIndexValid();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkScroll();
        this.setRowIndex(this.rowCount);
        return this.isRowIndexValid();
    }

    @Override
    public int getRow() {
        return this.state.rowIndex;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkScroll();
        if (row >= 0) {
            this.setRowIndex(row);
        } else {
            this.setRowIndex(this.rowCount + 1 + row);
        }
        return this.isRowIndexValid();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkScroll();
        if (rows != 0) {
            this.setRowIndex(this.state.rowIndex + rows);
        }
        return this.isRowIndexValid();
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkScroll();
        this.setRowIndex(this.state.rowIndex - 1);
        return this.isRowIndexValid();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        int resultSetType = this.getType();
        if (resultSetType == 1003 && direction != 1000) {
            throw new SQLException(String.format("Fetch direction %s cannot be used when result set type is %s", direction, resultSetType));
        }
        this.state.direction = direction;
    }

    @Override
    public int getFetchDirection() {
        return this.state.direction;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public YdbStatement getStatement() {
        return this.statement;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDateImpl(columnIndex, Date::new);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.getColumnIndex(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getDateImpl(columnIndex, Time::new);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.getColumnIndex(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getDateImpl(columnIndex, Timestamp::new);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        String copy = this.state.description.getters().readURL(this.state.value);
        if (this.state.nullValue) {
            return null;
        }
        try {
            return new URL(copy);
        }
        catch (MalformedURLException e) {
            throw new SQLException("Cannot cast as URL: " + this.result, e);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.getColumnIndex(columnLabel));
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.state.closed;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        String copy = this.state.description.getters().readNString(this.state.value);
        if (this.state.nullValue) {
            return null;
        }
        return copy;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.getColumnIndex(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.getColumnIndex(columnLabel));
    }

    @Override
    public Optional<Value<?>> getNativeColumn(int columnIndex) throws SQLException {
        this.initValueReader(columnIndex);
        if (this.state.nullValue) {
            return Optional.empty();
        }
        Value actualValue = this.state.value.getValue();
        if (actualValue instanceof OptionalValue) {
            return Optional.of(((OptionalValue)actualValue).get());
        }
        return Optional.of(actualValue);
    }

    @Override
    public Optional<Value<?>> getNativeColumn(String columnLabel) throws SQLException {
        return this.getNativeColumn(this.getColumnIndex(columnLabel));
    }

    @Override
    public ResultSetReader getYdbResultSetReader() {
        return this.result;
    }

    private <T> T getDateImpl(int columnIndex, LongFunction<T> fromMillis) throws SQLException {
        this.initValueReader(columnIndex);
        long longValue = this.state.description.getters().readDateMillis(this.state.value);
        if (this.state.nullValue) {
            return null;
        }
        return fromMillis.apply(longValue);
    }

    private boolean isNullValue(TypeDescription description, ValueReader value) {
        return description.isOptional() && !value.isOptionalItemPresent();
    }

    private void initValueReader(int columnIndex) throws SQLException {
        try {
            ValueReader value = this.result.getColumn(columnIndex - 1);
            TypeDescription description = TypeDescription.of(this.result.getColumnType(columnIndex - 1));
            this.state.value = value;
            this.state.description = description;
            this.state.nullValue = this.isNullValue(description, value);
        }
        catch (IllegalStateException e) {
            throw new SQLException("Current row index is out of bounds: " + this.state.rowIndex);
        }
    }

    private int getColumnIndex(String columnLabel) throws SQLException {
        int index = this.result.getColumnIndex(columnLabel);
        if (index < 0) {
            throw new SQLException("Column not found: " + columnLabel);
        }
        return index + 1;
    }

    private void checkScroll() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("ResultSet in TYPE_FORWARD_ONLY mode");
        }
    }

    private void setRowIndex(int rowIndex) {
        if (this.rowCount > 0) {
            int actualIndex = Math.max(Math.min(rowIndex, this.rowCount + 1), 0);
            this.state.rowIndex = actualIndex;
            this.result.setRowIndex(actualIndex - 1);
        }
    }

    private boolean isRowIndexValid() {
        return this.state.rowIndex > 0 && this.state.rowIndex <= this.rowCount;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("Named cursors are not supported");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("RowIds are not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("RowIds are not supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Cursor updates are not supported");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Object with type conversion is not supported yet");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Refs are not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Blobs are not supported");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Clobs are not supported");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Object with type conversion is not supported yet");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Refs are not supported");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Blobs are not supported");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Clobs are not supported");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("NClobs are not supported");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("NClobs are not supported");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXMLs are not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQLXMLs are not supported");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("AsciiStreams are not supported");
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("AsciiStreams are not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Object with type conversion is not supported yet");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Object with type conversion is not supported yet");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    private static class MutableState {
        private int rowIndex;
        private ValueReader value;
        private TypeDescription description;
        boolean nullValue;
        private int direction = 1002;
        private boolean closed;

        private MutableState() {
        }
    }
}

