/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query;

import java.sql.SQLException;
import tech.ydb.jdbc.query.QueryType;
import tech.ydb.jdbc.query.YdbExpression;
import tech.ydb.jdbc.query.YdbQueryBuilder;
import tech.ydb.jdbc.settings.YdbQueryProperties;

public class JdbcQueryLexer {
    private JdbcQueryLexer() {
    }

    public static void buildQuery(YdbQueryBuilder builder, YdbQueryProperties options) throws SQLException {
        int fragmentStart = 0;
        boolean nextExpression = true;
        boolean detectJdbcArgs = false;
        char[] chars = builder.getOriginSQL().toCharArray();
        block8: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\'': {
                    i = JdbcQueryLexer.parseSingleQuotes(chars, i);
                    continue block8;
                }
                case '\"': {
                    i = JdbcQueryLexer.parseDoubleQuotes(chars, i);
                    continue block8;
                }
                case '-': {
                    i = JdbcQueryLexer.parseLineComment(chars, i);
                    continue block8;
                }
                case '/': {
                    i = JdbcQueryLexer.parseBlockComment(chars, i);
                    continue block8;
                }
                case ';': {
                    nextExpression = true;
                    detectJdbcArgs = false;
                    continue block8;
                }
                case '?': {
                    if (!detectJdbcArgs) continue block8;
                    builder.append(chars, fragmentStart, i - fragmentStart);
                    if (i + 1 < chars.length && chars[i + 1] == '?') {
                        builder.append('?');
                        ++i;
                    } else {
                        String binded = builder.createNextArgName();
                        builder.append(binded);
                    }
                    fragmentStart = i + 1;
                    continue block8;
                }
                default: {
                    if (!nextExpression || !Character.isJavaIdentifierStart(ch)) continue block8;
                    nextExpression = false;
                    if (!options.isDetectQueryType()) continue block8;
                    if (JdbcQueryLexer.parseSelectKeyword(chars, i)) {
                        builder.addExpression(QueryType.DATA_QUERY, YdbExpression.SELECT);
                        detectJdbcArgs = options.isDetectJdbcParameters();
                        continue block8;
                    }
                    if (JdbcQueryLexer.parseUpdateKeyword(chars, i) || JdbcQueryLexer.parseInsertKeyword(chars, i) || JdbcQueryLexer.parseUpsertKeyword(chars, i) || JdbcQueryLexer.parseDeleteKeyword(chars, i) || JdbcQueryLexer.parseReplaceKeyword(chars, i)) {
                        builder.addExpression(QueryType.DATA_QUERY, YdbExpression.OTHER_DML);
                        detectJdbcArgs = options.isDetectJdbcParameters();
                        continue block8;
                    }
                    if (JdbcQueryLexer.parseAlterKeyword(chars, i) || JdbcQueryLexer.parseCreateKeyword(chars, i) || JdbcQueryLexer.parseDropKeyword(chars, i)) {
                        builder.addExpression(QueryType.SCHEME_QUERY, YdbExpression.DDL);
                        continue block8;
                    }
                    if (JdbcQueryLexer.parseScanKeyword(chars, i)) {
                        builder.addExpression(QueryType.SCAN_QUERY, YdbExpression.SELECT);
                        detectJdbcArgs = options.isDetectJdbcParameters();
                        builder.append(chars, fragmentStart, i - fragmentStart);
                        fragmentStart = i + 5;
                        continue block8;
                    }
                    if (!JdbcQueryLexer.parseExplainKeyword(chars, i)) continue block8;
                    builder.addExpression(QueryType.EXPLAIN_QUERY, YdbExpression.SELECT);
                    detectJdbcArgs = options.isDetectJdbcParameters();
                    builder.append(chars, fragmentStart, i - fragmentStart);
                    fragmentStart = i + 8;
                }
            }
        }
        if (fragmentStart < chars.length) {
            builder.append(chars, fragmentStart, chars.length - fragmentStart);
        }
    }

    private static int parseSingleQuotes(char[] query, int offset) {
        block4: while (++offset < query.length) {
            switch (query[offset]) {
                case '\\': {
                    ++offset;
                    continue block4;
                }
                case '\'': {
                    return offset;
                }
            }
        }
        return query.length;
    }

    private static int parseDoubleQuotes(char[] query, int offset) {
        while (++offset < query.length && query[offset] != '\"') {
        }
        return offset;
    }

    private static int parseLineComment(char[] query, int offset) {
        block1: {
            if (offset + 1 >= query.length || query[offset + 1] != '-') break block1;
            while (offset + 1 < query.length && query[++offset] != '\r' && query[offset] != '\n') {
            }
        }
        return offset;
    }

    private static int parseBlockComment(char[] query, int offset) {
        if (offset + 1 < query.length && query[offset + 1] == '*') {
            int level = 1;
            offset += 2;
            while (offset < query.length) {
                switch (query[offset - 1]) {
                    case '*': {
                        if (query[offset] != '/') break;
                        --level;
                        ++offset;
                        break;
                    }
                    case '/': {
                        if (query[offset] != '*') break;
                        ++level;
                        ++offset;
                        break;
                    }
                }
                if (level == 0) {
                    --offset;
                    break;
                }
                ++offset;
            }
        }
        return offset;
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
    }

    private static boolean parseAlterKeyword(char[] query, int offset) {
        if (query.length < offset + 6) {
            return false;
        }
        return (query[offset] | 0x20) == 97 && (query[offset + 1] | 0x20) == 108 && (query[offset + 2] | 0x20) == 116 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 114 && JdbcQueryLexer.isSpace(query[offset + 5]);
    }

    private static boolean parseCreateKeyword(char[] query, int offset) {
        if (query.length < offset + 7) {
            return false;
        }
        return (query[offset] | 0x20) == 99 && (query[offset + 1] | 0x20) == 114 && (query[offset + 2] | 0x20) == 101 && (query[offset + 3] | 0x20) == 97 && (query[offset + 4] | 0x20) == 116 && (query[offset + 5] | 0x20) == 101 && JdbcQueryLexer.isSpace(query[offset + 6]);
    }

    private static boolean parseDropKeyword(char[] query, int offset) {
        if (query.length < offset + 5) {
            return false;
        }
        return (query[offset] | 0x20) == 100 && (query[offset + 1] | 0x20) == 114 && (query[offset + 2] | 0x20) == 111 && (query[offset + 3] | 0x20) == 112 && JdbcQueryLexer.isSpace(query[offset + 4]);
    }

    private static boolean parseScanKeyword(char[] query, int offset) {
        if (query.length < offset + 5) {
            return false;
        }
        return (query[offset] | 0x20) == 115 && (query[offset + 1] | 0x20) == 99 && (query[offset + 2] | 0x20) == 97 && (query[offset + 3] | 0x20) == 110 && JdbcQueryLexer.isSpace(query[offset + 4]);
    }

    private static boolean parseExplainKeyword(char[] query, int offset) {
        if (query.length < offset + 8) {
            return false;
        }
        return (query[offset] | 0x20) == 101 && (query[offset + 1] | 0x20) == 120 && (query[offset + 2] | 0x20) == 112 && (query[offset + 3] | 0x20) == 108 && (query[offset + 4] | 0x20) == 97 && (query[offset + 5] | 0x20) == 105 && (query[offset + 6] | 0x20) == 110 && JdbcQueryLexer.isSpace(query[offset + 7]);
    }

    private static boolean parseSelectKeyword(char[] query, int offset) {
        if (query.length < offset + 7) {
            return false;
        }
        return (query[offset] | 0x20) == 115 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 108 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 99 && (query[offset + 5] | 0x20) == 116 && JdbcQueryLexer.isSpace(query[offset + 6]);
    }

    private static boolean parseUpdateKeyword(char[] query, int offset) {
        if (query.length < offset + 7) {
            return false;
        }
        return (query[offset] | 0x20) == 117 && (query[offset + 1] | 0x20) == 112 && (query[offset + 2] | 0x20) == 100 && (query[offset + 3] | 0x20) == 97 && (query[offset + 4] | 0x20) == 116 && (query[offset + 5] | 0x20) == 101 && JdbcQueryLexer.isSpace(query[offset + 6]);
    }

    private static boolean parseUpsertKeyword(char[] query, int offset) {
        if (query.length < offset + 7) {
            return false;
        }
        return (query[offset] | 0x20) == 117 && (query[offset + 1] | 0x20) == 112 && (query[offset + 2] | 0x20) == 115 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 114 && (query[offset + 5] | 0x20) == 116 && JdbcQueryLexer.isSpace(query[offset + 6]);
    }

    private static boolean parseInsertKeyword(char[] query, int offset) {
        if (query.length < offset + 7) {
            return false;
        }
        return (query[offset] | 0x20) == 105 && (query[offset + 1] | 0x20) == 110 && (query[offset + 2] | 0x20) == 115 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 114 && (query[offset + 5] | 0x20) == 116 && JdbcQueryLexer.isSpace(query[offset + 6]);
    }

    private static boolean parseDeleteKeyword(char[] query, int offset) {
        if (query.length < offset + 7) {
            return false;
        }
        return (query[offset] | 0x20) == 100 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 108 && (query[offset + 3] | 0x20) == 101 && (query[offset + 4] | 0x20) == 116 && (query[offset + 5] | 0x20) == 101 && JdbcQueryLexer.isSpace(query[offset + 6]);
    }

    private static boolean parseReplaceKeyword(char[] query, int offset) {
        if (query.length < offset + 8) {
            return false;
        }
        return (query[offset] | 0x20) == 114 && (query[offset + 1] | 0x20) == 101 && (query[offset + 2] | 0x20) == 112 && (query[offset + 3] | 0x20) == 108 && (query[offset + 4] | 0x20) == 97 && (query[offset + 5] | 0x20) == 99 && (query[offset + 8] | 0x20) == 101 && JdbcQueryLexer.isSpace(query[offset + 7]);
    }
}

