/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query.params;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.jdbc.query.JdbcParams;
import tech.ydb.jdbc.query.params.ParamDescription;
import tech.ydb.table.query.Params;
import tech.ydb.table.values.ListType;
import tech.ydb.table.values.ListValue;
import tech.ydb.table.values.StructType;
import tech.ydb.table.values.StructValue;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public class BatchedParams
implements JdbcParams {
    private final String batchParamName;
    private final Map<String, ParamDescription> paramsByName;
    private final ParamDescription[] params;
    private final List<StructValue> batchList = new ArrayList<StructValue>();
    private final Map<String, Value<?>> currentValues = new HashMap();

    private BatchedParams(String listName, StructType structType) {
        this.batchParamName = listName;
        this.paramsByName = new HashMap<String, ParamDescription>();
        this.params = new ParamDescription[structType.getMembersCount()];
        HashMap<String, Type> types = new HashMap<String, Type>();
        for (int idx = 0; idx < structType.getMembersCount(); ++idx) {
            types.put(structType.getMemberName(idx), structType.getMemberType(idx));
        }
        HashSet<String> indexedNames = new HashSet<String>();
        for (int idx = 0; idx < structType.getMembersCount(); ++idx) {
            ParamDescription paramDesc;
            String indexedName = "p" + (1 + idx);
            if (!types.containsKey(indexedName)) continue;
            String displayName = "$" + indexedName;
            TypeDescription typeDesc = TypeDescription.of((Type)types.get(indexedName));
            this.params[idx] = paramDesc = new ParamDescription(idx, indexedName, displayName, typeDesc);
            this.paramsByName.put(indexedName, paramDesc);
            indexedNames.add(indexedName);
        }
        Iterator sortedIter = new TreeSet(types.keySet()).iterator();
        for (int idx = 0; idx < this.params.length; ++idx) {
            ParamDescription paramDesc;
            if (this.params[idx] != null) continue;
            String param = (String)sortedIter.next();
            while (indexedNames.contains(param)) {
                param = (String)sortedIter.next();
            }
            String displayName = "$" + param;
            TypeDescription typeDesc = TypeDescription.of((Type)types.get(param));
            this.params[idx] = paramDesc = new ParamDescription(idx, param, displayName, typeDesc);
            this.paramsByName.put(param, paramDesc);
        }
    }

    @Override
    public int parametersCount() {
        return this.params.length;
    }

    @Override
    public int batchSize() {
        return this.batchList.size();
    }

    @Override
    public void clearParameters() {
        this.currentValues.clear();
    }

    @Override
    public void addBatch() throws SQLException {
        this.batchList.add(this.validatedCurrentStruct());
        this.currentValues.clear();
    }

    @Override
    public void clearBatch() {
        this.batchList.clear();
    }

    private StructValue validatedCurrentStruct() throws SQLException {
        for (ParamDescription prm : this.params) {
            if (this.currentValues.containsKey(prm.name())) continue;
            if (prm.type().isOptional()) {
                this.currentValues.put(prm.name(), (Value<?>)prm.type().nullValue());
                continue;
            }
            throw new SQLDataException("Missing value for parameter: " + prm.displayName());
        }
        return StructValue.of(this.currentValues);
    }

    @Override
    public Params getCurrentParams() throws SQLException {
        ListValue list = ListValue.of((Value)this.validatedCurrentStruct());
        return Params.of((String)this.batchParamName, (Value)list);
    }

    @Override
    public List<Params> getBatchParams() {
        if (this.batchList.isEmpty()) {
            return Collections.emptyList();
        }
        Value[] batchStructs = this.batchList.toArray(new Value[0]);
        ListValue list = ListValue.of((Value[])batchStructs);
        return Collections.singletonList(Params.of((String)this.batchParamName, (Value)list));
    }

    @Override
    public void setParam(int index, Object obj, Type type) throws SQLException {
        if (index <= 0 || index > this.params.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        ParamDescription desc = this.params[index - 1];
        Value<?> value = desc.getValue(obj);
        this.currentValues.put(desc.name(), value);
    }

    @Override
    public void setParam(String name, Object obj, Type type) throws SQLException {
        if (!this.paramsByName.containsKey(name)) {
            throw new SQLException("Parameter not found: " + name);
        }
        ParamDescription desc = this.paramsByName.get(name);
        Value<?> value = desc.getValue(obj);
        this.currentValues.put(desc.name(), value);
    }

    @Override
    public String getNameByIndex(int index) throws SQLException {
        if (index <= 0 || index > this.params.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        return this.params[index - 1].name();
    }

    @Override
    public TypeDescription getDescription(int index) throws SQLException {
        if (index <= 0 || index > this.params.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        return this.params[index - 1].type();
    }

    public static BatchedParams tryCreateBatched(Map<String, Type> types) {
        if (types.size() != 1) {
            return null;
        }
        String listName = types.keySet().iterator().next();
        Type type = types.get(listName);
        if (type.getKind() != Type.Kind.LIST) {
            return null;
        }
        ListType listType = (ListType)type;
        Type innerType = listType.getItemType();
        if (innerType.getKind() != Type.Kind.STRUCT) {
            return null;
        }
        StructType itemType = (StructType)innerType;
        return new BatchedParams(listName, itemType);
    }
}

