/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.jdbc.query.params;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.ydb.jdbc.common.TypeDescription;
import tech.ydb.jdbc.query.JdbcParams;
import tech.ydb.jdbc.query.params.ParamDescription;
import tech.ydb.table.query.Params;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;

public class InMemoryParams
implements JdbcParams {
    private final String[] paramNames;
    private final Map<String, Value<?>> paramValues;
    private final List<Params> batchList;

    public InMemoryParams(List<String> params) {
        this.paramNames = params.toArray(new String[0]);
        this.paramValues = new HashMap();
        this.batchList = new ArrayList<Params>();
    }

    @Override
    public int parametersCount() {
        return this.paramValues.size();
    }

    @Override
    public int batchSize() {
        return this.batchList.size();
    }

    @Override
    public void addBatch() {
        this.batchList.add(Params.copyOf(this.paramValues));
        this.paramValues.clear();
    }

    @Override
    public void clearBatch() {
        this.batchList.clear();
    }

    @Override
    public void clearParameters() {
        this.paramValues.clear();
    }

    @Override
    public List<Params> getBatchParams() {
        return this.batchList;
    }

    @Override
    public Params getCurrentParams() {
        return Params.copyOf(this.paramValues);
    }

    @Override
    public String getNameByIndex(int index) throws SQLException {
        if (index <= 0 || index > this.paramNames.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        return this.paramNames[index - 1];
    }

    @Override
    public TypeDescription getDescription(int index) throws SQLException {
        if (index <= 0 || index > this.paramNames.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        String name = this.paramNames[index - 1];
        Value<?> arg = this.paramValues.get(name);
        return arg == null ? null : TypeDescription.of(arg.getType());
    }

    @Override
    public void setParam(int index, Object obj, Type type) throws SQLException {
        if (index <= 0 || index > this.paramNames.length) {
            throw new SQLException("Parameter is out of range: " + index);
        }
        this.setParam(this.paramNames[index - 1], obj, type);
    }

    @Override
    public void setParam(String name, Object obj, Type type) throws SQLException {
        if (obj instanceof Value) {
            this.paramValues.put(name, (Value)obj);
            return;
        }
        ParamDescription desc = new ParamDescription(-1, name, TypeDescription.of(type));
        this.paramValues.put(name, desc.getValue(obj));
    }
}

