/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.test.junit5;

import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.grpc.GrpcTransport;
import tech.ydb.test.integration.YdbHelper;
import tech.ydb.test.integration.YdbHelperFactory;
import tech.ydb.test.integration.utils.ProxyGrpcTransport;

public class GrpcTransportExtension
extends ProxyGrpcTransport
implements ExecutionCondition,
AfterAllCallback,
AfterEachCallback,
BeforeAllCallback,
BeforeEachCallback {
    private static final Logger logger = LoggerFactory.getLogger(GrpcTransportExtension.class);
    private final Holder holder = new Holder();

    protected GrpcTransport origin() {
        return this.holder.transport();
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        if (!context.getTestInstance().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"OK");
        }
        if (!YdbHelperFactory.getInstance().isEnabled()) {
            return ConditionEvaluationResult.disabled((String)"Ydb helper is disabled");
        }
        return ConditionEvaluationResult.enabled((String)"OK");
    }

    public void beforeAll(ExtensionContext ec) throws Exception {
        this.holder.before(ec);
    }

    public void afterAll(ExtensionContext ec) throws Exception {
        this.holder.after(ec);
    }

    public void beforeEach(ExtensionContext ec) throws Exception {
        this.holder.before(ec);
    }

    public void afterEach(ExtensionContext ec) throws Exception {
        this.holder.after(ec);
    }

    private class Holder {
        private YdbHelper helper = null;
        private GrpcTransport transport = null;
        private ExtensionContext context = null;

        private Holder() {
        }

        public synchronized void before(ExtensionContext ec) {
            if (this.helper != null) {
                return;
            }
            YdbHelperFactory factory = YdbHelperFactory.getInstance();
            this.helper = factory.createHelper();
            if (this.helper != null) {
                this.context = ec;
                String path = "";
                if (ec.getTestClass().isPresent()) {
                    path = path + "/" + ((Class)ec.getTestClass().get()).getName();
                }
                if (ec.getTestMethod().isPresent()) {
                    path = path + "/" + ((Method)ec.getTestMethod().get()).getName();
                }
                logger.debug("create ydb helper for path {}", (Object)path);
                this.transport = this.helper.createTransport();
            }
        }

        public synchronized void after(ExtensionContext ec) {
            if (this.context != ec) {
                return;
            }
            if (this.transport != null) {
                this.transport.close();
                this.transport = null;
            }
            if (this.helper != null) {
                this.helper.close();
                this.helper = null;
            }
            this.context = null;
        }

        public synchronized GrpcTransport transport() {
            return this.transport;
        }
    }
}

