/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.common.retry;

import java.util.concurrent.ThreadLocalRandom;
import tech.ydb.common.retry.RetryPolicy;

public abstract class ExponentialBackoffRetry
implements RetryPolicy {
    private final long backoffMs;
    private final int backoffCeiling;

    protected ExponentialBackoffRetry(long backoffMs, int backoffCeiling) {
        this.backoffMs = backoffMs;
        this.backoffCeiling = backoffCeiling;
    }

    protected long backoffTimeMillis(int retryNumber) {
        int slots = 1 << Math.min(retryNumber, this.backoffCeiling);
        long delay = this.backoffMs * (long)slots;
        return delay + ThreadLocalRandom.current().nextLong(delay);
    }

    public long getBackoffMillis() {
        return this.backoffMs;
    }

    public int getBackoffCeiling() {
        return this.backoffCeiling;
    }
}

