/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.description;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TableTtl {
    @Nonnull
    private final TtlMode ttlMode;
    @Nullable
    private final String dateTimeColumn;
    @Nullable
    private final Integer expireAfterSeconds;

    public TableTtl(@Nonnull TtlMode ttlMode, @Nonnull String dateTimeColumn, @Nonnull Integer expireAfterSeconds) {
        this.ttlMode = ttlMode;
        this.dateTimeColumn = dateTimeColumn;
        this.expireAfterSeconds = expireAfterSeconds;
    }

    public TableTtl() {
        this.ttlMode = TtlMode.NOT_SET;
        this.dateTimeColumn = null;
        this.expireAfterSeconds = null;
    }

    @Nonnull
    public TtlMode getTtlMode() {
        return this.ttlMode;
    }

    @Nullable
    public String getDateTimeColumn() {
        return this.dateTimeColumn;
    }

    @Nullable
    public Integer getExpireAfterSeconds() {
        return this.expireAfterSeconds;
    }

    public static enum TtlMode {
        DATE_TYPE_COLUMN(1),
        VALUE_SINCE_UNIX_EPOCH(2),
        NOT_SET(0);

        private final int caseMapping;

        private TtlMode(int caseMapping) {
            this.caseMapping = caseMapping;
        }

        public static TtlMode forCase(int value) {
            for (TtlMode mode : TtlMode.values()) {
                if (mode.caseMapping != value) continue;
                return mode;
            }
            throw new IllegalArgumentException("No TTL mode defined for specified value");
        }
    }
}

