/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.result.impl;

import tech.ydb.proto.ValueProtos;
import tech.ydb.table.result.ValueReader;
import tech.ydb.table.result.impl.AbstractValueReader;

final class ProtoListValueReader
extends AbstractValueReader {
    private final ValueProtos.Type type;
    private final AbstractValueReader itemReader;
    private ValueProtos.Value value;

    ProtoListValueReader(ValueProtos.Type type, AbstractValueReader itemReader) {
        this.type = type;
        this.itemReader = itemReader;
    }

    @Override
    protected ValueProtos.Type getProtoType() {
        return this.type;
    }

    @Override
    protected ValueProtos.Value getProtoValue() {
        return this.value;
    }

    @Override
    protected void setProtoValue(ValueProtos.Value value) {
        this.value = value;
    }

    @Override
    public int getListItemsCount() {
        return this.value.getItemsCount();
    }

    @Override
    public ValueReader getListItem(int index) {
        this.itemReader.setProtoValue(this.value.getItems(index));
        return this.itemReader;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("List[");
        for (int i = 0; i < this.getListItemsCount(); ++i) {
            this.getListItem(i).toString(sb);
            sb.append(", ");
        }
        if (this.getListItemsCount() > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
    }
}

