/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.result.impl;

import tech.ydb.proto.ValueProtos;
import tech.ydb.table.result.ValueReader;
import tech.ydb.table.result.impl.AbstractValueReader;

final class ProtoOptionalValueReader
extends AbstractValueReader {
    private final ValueProtos.Type type;
    private final AbstractValueReader itemReader;
    private boolean present = false;
    private ValueProtos.Value value;

    ProtoOptionalValueReader(ValueProtos.Type type, AbstractValueReader itemReader) {
        this.type = type;
        this.itemReader = itemReader;
    }

    @Override
    protected ValueProtos.Type getProtoType() {
        return this.type;
    }

    @Override
    protected ValueProtos.Value getProtoValue() {
        return this.value;
    }

    @Override
    protected void setProtoValue(ValueProtos.Value value) {
        this.value = value;
        switch (value.getValueCase()) {
            case NESTED_VALUE: {
                this.present = true;
                this.itemReader.setProtoValue(value.getNestedValue());
                break;
            }
            case NULL_FLAG_VALUE: {
                this.present = false;
                this.itemReader.setProtoValue(value);
                break;
            }
            default: {
                this.present = true;
                this.itemReader.setProtoValue(value);
            }
        }
    }

    @Override
    public boolean isOptionalItemPresent() {
        return this.present;
    }

    @Override
    public ValueReader getOptionalItem() {
        return this.present ? this.itemReader : null;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.isOptionalItemPresent()) {
            sb.append("Some[");
            this.getOptionalItem().toString(sb);
            sb.append(']');
        } else {
            sb.append("Empty[]");
        }
    }
}

