/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.values;

import java.util.List;
import tech.ydb.proto.ValueProtos;
import tech.ydb.table.values.ListValue;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;
import tech.ydb.table.values.proto.ProtoType;

public final class ListType
implements Type {
    private final Type itemType;

    private ListType(Type itemType) {
        this.itemType = itemType;
    }

    public static ListType of(Type itemType) {
        return new ListType(itemType);
    }

    public Type getItemType() {
        return this.itemType;
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.LIST;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListType listType = (ListType)o;
        return this.itemType.equals(listType.getItemType());
    }

    @Override
    public int hashCode() {
        return 31 * Type.Kind.LIST.hashCode() + this.itemType.hashCode();
    }

    @Override
    public String toString() {
        return "List<" + this.itemType + '>';
    }

    @Override
    public ValueProtos.Type toPb() {
        return ProtoType.getList(this.itemType.toPb());
    }

    public ListValue emptyValue() {
        return new ListValue(this, Value.EMPTY_ARRAY);
    }

    public ListValue newValue(List<? extends Value<?>> items) {
        if (items.isEmpty()) {
            return this.emptyValue();
        }
        return new ListValue(this, items.toArray(Value.EMPTY_ARRAY));
    }

    public ListValue newValueCopy(Value<?>[] items) {
        if (items.length == 0) {
            return this.emptyValue();
        }
        return this.newValueOwn((Value[])items.clone());
    }

    public ListValue newValueOwn(Value<?> ... items) {
        if (items.length == 0) {
            return this.emptyValue();
        }
        return new ListValue(this, items);
    }
}

