/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.values;

import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import tech.ydb.proto.ValueProtos;
import tech.ydb.table.values.OptionalType;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;
import tech.ydb.table.values.proto.ProtoValue;

@ParametersAreNonnullByDefault
public class OptionalValue
implements Value<OptionalType> {
    private final OptionalType type;
    @Nullable
    private final Value<?> value;

    OptionalValue(OptionalType type, @Nullable Value<?> value) {
        this.type = type;
        this.value = value;
    }

    public static OptionalValue of(Value<?> value) {
        return new OptionalValue(OptionalType.of(value.getType()), Objects.requireNonNull(value, "value"));
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public Value<?> get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public Value<?> orElse(Value<?> other) {
        return this.value != null ? this.value : other;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionalValue that = (OptionalValue)o;
        if (this.value == null) {
            return that.value == null;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        if (this.value == null) {
            return 2017;
        }
        return 31 * Type.Kind.OPTIONAL.hashCode() + this.value.hashCode();
    }

    public String toString() {
        if (this.value == null) {
            return "Empty[]";
        }
        return "Some[" + this.value.toString() + ']';
    }

    @Override
    public OptionalType getType() {
        return this.type;
    }

    @Override
    public ValueProtos.Value toPb() {
        if (this.isPresent()) {
            ValueProtos.Value pb = this.get().toPb();
            boolean implicit = this.type.getItemType().getKind() == Type.Kind.PRIMITIVE || this.type.getItemType().getKind() == Type.Kind.DECIMAL;
            return implicit ? pb : ProtoValue.optional(pb);
        }
        return ProtoValue.optional();
    }
}

