/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.values;

import java.util.List;
import tech.ydb.proto.ValueProtos;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.Value;
import tech.ydb.table.values.VariantValue;
import tech.ydb.table.values.proto.ProtoType;

public final class VariantType
implements Type {
    private final Type[] itemTypes;

    private VariantType(Type ... itemTypes) {
        this.itemTypes = itemTypes;
    }

    public static VariantType ofCopy(Type ... itemTypes) {
        return new VariantType((Type[])itemTypes.clone());
    }

    public static VariantType ofOwn(Type ... itemTypes) {
        return new VariantType(itemTypes);
    }

    public static VariantType of(List<Type> itemTypes) {
        return new VariantType(itemTypes.toArray(Type.EMPTY_ARRAY));
    }

    public int getItemsCount() {
        return this.itemTypes.length;
    }

    public Type getItemType(int index) {
        return this.itemTypes[index];
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.VARIANT;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != VariantType.class) {
            return false;
        }
        VariantType variantType = (VariantType)o;
        int itemsCount = this.getItemsCount();
        if (itemsCount != variantType.getItemsCount()) {
            return false;
        }
        for (int i = 0; i < itemsCount; ++i) {
            if (this.getItemType(i).equals(variantType.getItemType(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 31 * Type.Kind.VARIANT.hashCode();
        int count = this.getItemsCount();
        for (int i = 0; i < count; ++i) {
            h = 31 * h + this.getItemType(i).hashCode();
        }
        return h;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Variant<");
        int count = this.getItemsCount();
        for (int i = 0; i < count; ++i) {
            sb.append(this.getItemType(i)).append(", ");
        }
        if (count != 0) {
            sb.setLength(sb.length() - 1);
        }
        sb.append('>');
        return sb.toString();
    }

    @Override
    public ValueProtos.Type toPb() {
        ValueProtos.TupleType.Builder tupleType = ValueProtos.TupleType.newBuilder();
        for (Type itemType : this.itemTypes) {
            tupleType.addElements(itemType.toPb());
        }
        return ProtoType.getVariant(tupleType.build());
    }

    public VariantValue newValue(Value<?> item, int typeIndex) {
        return new VariantValue(this, item, typeIndex);
    }
}

