/*
 * Decompiled with CFR 0.152.
 */
package tel.panfilov.maven.extensions.imh;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import tel.panfilov.maven.extensions.imh.IMHWorkspaceReader;
import tel.panfilov.maven.extensions.imh.RootProjectLocator;

@Component(role=AbstractMavenLifecycleParticipant.class)
public class IMHLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    public static final String ENABLED_FLAG = "imh.ext";
    @Requirement
    private PlexusContainer container;
    @Requirement
    private Logger logger;
    @Requirement
    private RootProjectLocator rootProjectLocator;
    @Requirement
    private IMHWorkspaceReader workspaceReader;

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        this.logger.debug("Fake repository extension - setting up workspace");
        this.setupWorkspaceReader(session);
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        for (MavenProject project : session.getProjects()) {
            this.workspaceReader.addProject(project);
        }
    }

    protected void setupWorkspaceReader(MavenSession mavenSession) {
        try {
            if (!this.isEnabled(mavenSession)) {
                this.logger.debug("inter-module helper extension disabled");
                return;
            }
            MavenExecutionRequest request = mavenSession.getRequest();
            RepositorySystemSession repositorySystemSession = this.tempRepositorySession(mavenSession);
            if (request.getPom() == null || !request.getPom().isFile()) {
                this.logger.debug("Pom file not found");
                return;
            }
            MavenProject project = this.getProject(request, repositorySystemSession);
            MavenProject rootProject = this.rootProjectLocator.getRootProject(project, request.getMultiModuleProjectDirectory());
            List<MavenProject> workspaceProjects = this.collectWorkspaceProjects(rootProject, request, repositorySystemSession);
            for (MavenProject mavenProject : workspaceProjects) {
                this.workspaceReader.addProject(mavenProject);
            }
        }
        catch (ProjectBuildingException | ComponentLookupException ex) {
            this.logger.error("Failed to setup workspace reader", ex);
        }
    }

    protected MavenProject getProject(MavenExecutionRequest request, RepositorySystemSession repositorySystemSession) throws ProjectBuildingException, ComponentLookupException {
        ProjectBuildingRequest buildingRequest = this.projectBuildingRequest(request, repositorySystemSession);
        ProjectBuilder projectBuilder = (ProjectBuilder)this.container.lookup(ProjectBuilder.class, "imh");
        return projectBuilder.build(request.getPom(), buildingRequest).getProject();
    }

    protected List<MavenProject> collectWorkspaceProjects(MavenProject rootProject, MavenExecutionRequest request, RepositorySystemSession repositorySystemSession) throws ProjectBuildingException, ComponentLookupException {
        List<File> poms = Collections.singletonList(rootProject.getFile());
        ProjectBuildingRequest buildingRequest = this.projectBuildingRequest(request, repositorySystemSession);
        ProjectBuilder projectBuilder = (ProjectBuilder)this.container.lookup(ProjectBuilder.class, "imh");
        List results = projectBuilder.build(poms, true, buildingRequest);
        ArrayList<MavenProject> discovered = new ArrayList<MavenProject>();
        for (ProjectBuildingResult result : results) {
            discovered.add(result.getProject());
        }
        return discovered;
    }

    protected boolean isEnabled(MavenSession session) {
        return "true".equals(session.getUserProperties().get(ENABLED_FLAG));
    }

    private ProjectBuildingRequest projectBuildingRequest(MavenExecutionRequest request, RepositorySystemSession systemSession) {
        ProjectBuildingRequest buildingRequest = request.getProjectBuildingRequest();
        buildingRequest = new DefaultProjectBuildingRequest(buildingRequest);
        buildingRequest.setRepositorySession(systemSession);
        buildingRequest.setResolveDependencies(false);
        buildingRequest.setProcessPlugins(true);
        buildingRequest.setResolveVersionRanges(false);
        buildingRequest.setValidationLevel(0);
        return buildingRequest;
    }

    protected RepositorySystemSession tempRepositorySession(MavenSession session) {
        DefaultRepositorySystemSession result = new DefaultRepositorySystemSession(session.getRepositorySession());
        result.setWorkspaceReader(null);
        result.setArtifactDescriptorPolicy((s, r) -> 3);
        result.setCache((RepositoryCache)new DefaultRepositoryCache());
        return result;
    }
}

