/*
 * Decompiled with CFR 0.152.
 */
package tel.panfilov.maven.extensions.imh;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.eclipse.aether.util.StringUtils;

@Component(role=IMHWorkspaceReader.class)
public class IMHWorkspaceReader
implements WorkspaceReader {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement
    private Logger logger;
    private final WorkspaceRepository repository = new WorkspaceRepository();
    private long buildStartTime = -1L;
    private final Map<String, MavenProject> projectMap = new HashMap<String, MavenProject>();

    public void addProject(MavenProject project) {
        this.projectMap.put(this.getProjectId(project), project);
    }

    public void setBuildStartTime(long buildStartTime) {
        this.buildStartTime = buildStartTime;
    }

    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    public File findArtifact(Artifact artifact) {
        if ("pom".equals(artifact.getExtension())) {
            return this.getPom(artifact);
        }
        return this.getArtifact(artifact);
    }

    protected File getPom(Artifact artifact) {
        return Optional.of(this.getProjectId(artifact)).map(this.projectMap::get).map(MavenProject::getFile).filter(File::exists).orElse(null);
    }

    protected File getArtifact(Artifact artifact) {
        MavenProject project = this.projectMap.get(this.getProjectId(artifact));
        if (project == null) {
            return null;
        }
        File file = this.findProjectArtifact(project, artifact);
        if (file != null) {
            return file;
        }
        Build build = project.getBuild();
        StringBuilder name = new StringBuilder(build.getFinalName());
        if (!StringUtils.isEmpty((String)artifact.getClassifier())) {
            name.append('-').append(artifact.getClassifier());
        }
        name.append('.').append(artifact.getExtension());
        file = new File(build.getDirectory(), name.toString());
        if (this.isActual(file, artifact, project)) {
            return file;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isActual(File packaged, Artifact artifact, MavenProject project) {
        if (!packaged.exists()) return false;
        if (!packaged.isFile()) {
            return false;
        }
        Build build = project.getBuild();
        Path directory = this.isTestArtifact(artifact) ? Paths.get(build.getTestOutputDirectory(), new String[0]) : Paths.get(build.getOutputDirectory(), new String[0]);
        if (Files.notExists(directory, new LinkOption[0])) return true;
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return true;
        }
        try (Stream<Path> outputFiles = Files.walk(directory, new FileVisitOption[0]);){
            long artifactTime = Files.getLastModifiedTime(packaged.toPath(), new LinkOption[0]).toMillis();
            if (this.buildStartTime > 0L && artifactTime > this.buildStartTime) {
                boolean bl = true;
                return bl;
            }
            Iterator iterator = outputFiles.iterator();
            while (iterator.hasNext()) {
                long outputFileLastModified;
                Path outputFile = (Path)iterator.next();
                if (Files.isDirectory(outputFile, new LinkOption[0]) || (outputFileLastModified = Files.getLastModifiedTime(outputFile, new LinkOption[0]).toMillis()) <= artifactTime) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.logger.warn("Failed to check whether the packaged artifact is up-to-date, assuming it is", (Throwable)e);
            return true;
        }
    }

    public List<String> findVersions(Artifact artifact) {
        MavenProject project = this.projectMap.get(this.getProjectId(artifact));
        if (project != null) {
            return Collections.singletonList(project.getVersion());
        }
        return Collections.emptyList();
    }

    protected File findProjectArtifact(MavenProject project, Artifact requested) {
        String requestedId = this.getArtifactId(requested);
        return Stream.concat(Stream.of(project.getArtifact()), project.getAttachedArtifacts().stream()).filter(Objects::nonNull).map(RepositoryUtils::toArtifact).filter(a -> requestedId.equals(this.getArtifactId((Artifact)a))).filter(a -> Objects.equals(requested.getVersion(), a.getVersion())).map(Artifact::getFile).filter(Objects::nonNull).filter(File::exists).findFirst().orElse(null);
    }

    protected boolean isTestArtifact(Artifact artifact) {
        return "test-jar".equals(artifact.getProperty("type", "")) || "jar".equals(artifact.getExtension()) && "tests".equals(artifact.getClassifier());
    }

    protected String getProjectId(MavenProject project) {
        return project.getGroupId() + ':' + project.getArtifactId() + ':' + project.getVersion();
    }

    protected String getProjectId(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getVersion();
    }

    protected String getArtifactId(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getExtension() + ':' + artifact.getClassifier();
    }
}

