/*
 * Decompiled with CFR 0.152.
 */
package tel.panfilov.maven.extensions.imh;

import java.io.File;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=RootProjectLocator.class)
public class RootProjectLocator {
    public MavenProject getRootProject(MavenProject project, File rootDirectory) {
        MavenProject root = this.lookupByMultiModuleProjectDirectory(project, rootDirectory);
        if (root == null) {
            root = this.lookupRootByFolder(project);
        }
        if (root == null) {
            root = this.lookupRootByExecution(project);
        }
        if (root == null) {
            root = project;
        }
        return root;
    }

    protected MavenProject lookupByMultiModuleProjectDirectory(MavenProject project, File rootDirectory) {
        MavenProject root;
        if (rootDirectory == null) {
            return null;
        }
        for (root = project; root != null && !rootDirectory.equals(root.getBasedir()); root = root.getParent()) {
        }
        return root;
    }

    protected MavenProject lookupRootByFolder(MavenProject project) {
        MavenProject root;
        Predicate<MavenProject> hasMvnFolder = prj -> Optional.of(prj).map(MavenProject::getBasedir).map(dir -> new File((File)dir, ".mvn")).map(File::isDirectory).orElse(false);
        for (root = project; root != null && !hasMvnFolder.test(root); root = root.getParent()) {
        }
        return root;
    }

    protected MavenProject lookupRootByExecution(MavenProject project) {
        MavenProject root;
        for (root = project; root != null && !root.isExecutionRoot(); root = root.getParent()) {
        }
        return root;
    }
}

