/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.awss3postobjectpresigner;

import com.google.gson.annotations.Expose;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tel.schich.awss3postobjectpresigner.Condition;
import tel.schich.awss3postobjectpresigner.ContentLengthRangeCondition;
import tel.schich.awss3postobjectpresigner.EqualsCondition;
import tel.schich.awss3postobjectpresigner.StartsWithCondition;

final class Policy {
    @Expose
    public final String expiration;
    @Expose
    public final List<Object> conditions;

    Policy(String expiration, List<Object> conditions) {
        this.expiration = expiration;
        this.conditions = conditions;
    }

    public static Policy create(Instant expiration, List<Condition> conditions) {
        String expirationString = expiration != null ? DateTimeFormatter.ISO_INSTANT.format(expiration) : null;
        ArrayList<Object> encodedConditions = new ArrayList<Object>();
        for (Condition condition : conditions) {
            Condition cond;
            if (condition instanceof EqualsCondition) {
                cond = (EqualsCondition)condition;
                encodedConditions.add(Collections.singletonMap(((EqualsCondition)cond).field(), ((EqualsCondition)cond).value()));
                continue;
            }
            if (condition instanceof StartsWithCondition) {
                cond = (StartsWithCondition)condition;
                encodedConditions.add(new Object[]{"starts-with", "$" + ((StartsWithCondition)cond).field(), ((StartsWithCondition)cond).prefix()});
                continue;
            }
            if (condition instanceof ContentLengthRangeCondition) {
                cond = (ContentLengthRangeCondition)condition;
                encodedConditions.add(new Object[]{"content-length-range", ((ContentLengthRangeCondition)cond).minimumBytes(), ((ContentLengthRangeCondition)cond).maximumBytes()});
                continue;
            }
            throw new IllegalArgumentException("Unknown Condition type: " + condition.getClass().getName());
        }
        return new Policy(expirationString, encodedConditions);
    }
}

