/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.awss3postobjectpresigner;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.s3.S3Configuration;
import tel.schich.awss3postobjectpresigner.Condition;
import tel.schich.awss3postobjectpresigner.Conditions;
import tel.schich.awss3postobjectpresigner.EqualsCondition;
import tel.schich.awss3postobjectpresigner.Policy;
import tel.schich.awss3postobjectpresigner.S3PostObjectRequest;
import tel.schich.awss3postobjectpresigner.S3PresignedPostObjectRequest;

public final class S3PostObjectPresigner {
    static final DateTimeFormatter DATESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd", Locale.ENGLISH).withZone(ZoneOffset.UTC);
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final String SIGNATURE_ALGORITHM = "HmacSHA256";
    private static final Gson GSON = new Gson();
    private static final DateTimeFormatter AMZ_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH).withZone(ZoneOffset.UTC);
    private final Supplier<ProfileFile> profileFile = ProfileFile::defaultProfileFile;
    private final String profileName = ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();
    private final AwsCredentialsProvider credentialsProvider;
    private final S3Configuration serviceConfiguration;
    private final URI endpoint;
    private final Region region;

    S3PostObjectPresigner(Builder builder) {
        this.serviceConfiguration = builder.serviceConfiguration;
        this.region = builder.region != null ? builder.region : DefaultAwsRegionProviderChain.builder().profileFile(this.profileFile).profileName(this.profileName).build().getRegion();
        this.credentialsProvider = builder.credentialsProvider != null ? builder.credentialsProvider : DefaultCredentialsProvider.builder().profileFile(this.profileFile).profileName(this.profileName).build();
        this.endpoint = builder.endpointOverride != null ? builder.endpointOverride : new DefaultServiceEndpointBuilder("s3", "https").withRegion(this.region).withProfileFile(this.profileFile).withProfileName(this.profileName).getServiceEndpoint();
    }

    public S3PresignedPostObjectRequest presignPost(S3PostObjectRequest request) {
        URI endpoint;
        AwsCredentials credentials = this.credentialsProvider.resolveCredentials();
        Instant timestamp = Instant.now();
        String credentialsField = S3PostObjectPresigner.buildCredentialField(credentials, this.region);
        ArrayList<Condition> augmentedConditions = new ArrayList<Condition>(request.conditions());
        augmentedConditions.add(Conditions.algorithmEquals("AWS4-HMAC-SHA256"));
        augmentedConditions.add(Conditions.credentialEquals(credentialsField));
        augmentedConditions.add(Conditions.dateEquals(AMZ_DATE_FORMATTER.format(timestamp)));
        augmentedConditions.add(Conditions.bucketEquals(request.bucket()));
        Policy policy = Policy.create(request.expiration(), augmentedConditions);
        HashMap<String, String> fields = new HashMap<String, String>();
        for (Condition condition : augmentedConditions) {
            if (!(condition instanceof EqualsCondition)) continue;
            EqualsCondition equalsCondition = (EqualsCondition)condition;
            fields.put(equalsCondition.field(), equalsCondition.value());
        }
        String encodedPolicy = Base64.getEncoder().encodeToString(GSON.toJson((Object)policy).getBytes(StandardCharsets.UTF_8));
        fields.put("x-amz-signature", S3PostObjectPresigner.hexDump(S3PostObjectPresigner.signMac(S3PostObjectPresigner.generateSigningKey(credentials.secretAccessKey(), timestamp, this.region, "s3"), encodedPolicy.getBytes(StandardCharsets.UTF_8))));
        fields.put("Policy", encodedPolicy);
        try {
            if (this.serviceConfiguration.pathStyleAccessEnabled()) {
                endpoint = this.endpoint.resolve(URLEncoder.encode(request.bucket(), StandardCharsets.UTF_8.name()));
            } else {
                String hostWithBucket = request.bucket() + "." + this.endpoint.getHost();
                endpoint = new URI(this.endpoint.getScheme(), this.endpoint.getUserInfo(), hostWithBucket, this.endpoint.getPort(), this.endpoint.getPath(), this.endpoint.getQuery(), this.endpoint.getFragment());
            }
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return new S3PresignedPostObjectRequest(endpoint, fields);
    }

    private static byte[] signMac(byte[] key, byte[] data) {
        try {
            Mac mac = Mac.getInstance(SIGNATURE_ALGORITHM);
            mac.init(new SecretKeySpec(key, SIGNATURE_ALGORITHM));
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static byte[] generateSigningKey(String secretKey, Instant timestamp, Region region, String service) {
        byte[] secretKeyBytes = ("AWS4" + secretKey).getBytes(StandardCharsets.UTF_8);
        byte[] dateKeyBytes = S3PostObjectPresigner.signMac(secretKeyBytes, DATESTAMP_FORMATTER.format(timestamp).getBytes(StandardCharsets.UTF_8));
        byte[] dateRegionKeyBytes = S3PostObjectPresigner.signMac(dateKeyBytes, region.id().getBytes(StandardCharsets.UTF_8));
        byte[] dateRegionServiceKeyBytes = S3PostObjectPresigner.signMac(dateRegionKeyBytes, service.getBytes(StandardCharsets.UTF_8));
        return S3PostObjectPresigner.signMac(dateRegionServiceKeyBytes, "aws4_request".getBytes(StandardCharsets.UTF_8));
    }

    private static String buildCredentialField(AwsCredentials credentials, Region region) {
        return credentials.accessKeyId() + "/" + DATESTAMP_FORMATTER.format(ZonedDateTime.now()) + "/" + region.id() + "/s3/aws4_request";
    }

    private static String hexDump(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte _byte : data) {
            sb.append(HEX_CHARS[_byte >> 4 & 0xF]);
            sb.append(HEX_CHARS[_byte & 0xF]);
        }
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private S3Configuration serviceConfiguration = (S3Configuration)S3Configuration.builder().build();
        private AwsCredentialsProvider credentialsProvider;
        private URI endpointOverride = null;
        private Region region = null;

        public Builder serviceConfiguration(S3Configuration serviceConfiguration) {
            Objects.requireNonNull(serviceConfiguration);
            this.serviceConfiguration = serviceConfiguration;
            return this;
        }

        public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder endpointOverride(URI endpointOverride) {
            this.endpointOverride = endpointOverride;
            return this;
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public S3PostObjectPresigner build() {
            return new S3PostObjectPresigner(this);
        }
    }
}

