/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.jniaccess;

import java.util.Collections;
import java.util.List;
import javax.lang.model.util.Types;
import tel.schich.jniaccess.AccessedClass;
import tel.schich.jniaccess.AccessedField;
import tel.schich.jniaccess.GeneratorHelper;
import tel.schich.jniaccess.MethodParam;
import tel.schich.jniaccess.TypeHelper;
import tel.schich.jniaccess.WrappedElement;

public class FieldWrapper
extends WrappedElement {
    private final AccessedClass clazz;
    private final AccessedField field;
    private final List<MethodParam> writeParams;

    public FieldWrapper(Types types, boolean performanceCritical, AccessedClass clazz, AccessedField field) {
        super(types, performanceCritical);
        this.clazz = clazz;
        this.field = field;
        this.writeParams = Collections.singletonList(new MethodParam("value", field.getElement(), field.getType()));
    }

    private void generateReadSig(StringBuilder out) {
        String name = GeneratorHelper.functionName("read", this.clazz, this.field.getName());
        GeneratorHelper.generateFunctionSignature(this.getTypes(), out, name, this.field.getType(), !this.field.isStatic(), Collections.emptyList(), false);
    }

    private void generateReadImpl(StringBuilder out) {
        this.generateReadSig(out);
        this.generateImplBody(out, false);
    }

    private String generateWriteFunctionName() {
        return GeneratorHelper.functionName("write", this.clazz, this.field.getName());
    }

    private void generateWriteSig(StringBuilder out, boolean cStrings) {
        GeneratorHelper.generateFunctionSignature(this.getTypes(), out, this.generateWriteFunctionName(), TypeHelper.getVoid(this.getTypes()), !this.field.isStatic(), this.writeParams, cStrings);
    }

    private void generateWriteImpl(StringBuilder out) {
        this.generateWriteSig(out, false);
        this.generateImplBody(out, true);
    }

    private void generateImplBody(StringBuilder out, boolean set) {
        out.append(" {\n");
        GeneratorHelper.generateClassLookup(out, "class", this.clazz, "    ");
        out.append('\n');
        GeneratorHelper.generateFieldLookup(this.getTypes(), out, "field", "class", this.field, "    ");
        out.append('\n');
        out.append("    (*env)->");
        out.append(set ? "Set" : "Get");
        if (this.field.isStatic()) {
            out.append("Static");
        }
        out.append(TypeHelper.getJNIHelperType(this.field.getType()));
        out.append("Field(env, ");
        out.append(this.field.isStatic() ? "class" : "instance");
        out.append(", field");
        if (set) {
            out.append(", value");
        }
        out.append(");\n");
        out.append("}\n");
    }

    @Override
    public void generateDeclarations(StringBuilder out) {
        this.generateReadSig(out);
        out.append(";\n");
        if (!this.field.isFinal()) {
            this.generateWriteSig(out, false);
            out.append(";\n");
            if (TypeHelper.isString(this.getTypes(), this.field.getType())) {
                this.generateWriteSig(out, true);
                out.append(";\n");
            }
        }
        out.append("\n");
    }

    @Override
    public void generateImplementations(StringBuilder out) {
        this.generateReadImpl(out);
        out.append("\n");
        if (!this.field.isFinal()) {
            this.generateWriteImpl(out);
            out.append("\n");
            if (TypeHelper.isString(this.getTypes(), this.field.getType())) {
                GeneratorHelper.generateJStringFunctionOverload(this.getTypes(), out, this.generateWriteFunctionName(), !this.field.isStatic(), TypeHelper.getVoid(this.getTypes()), this.writeParams);
                out.append("\n");
            }
        }
        out.append("\n");
    }
}

