/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.jniaccess;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import tel.schich.jniaccess.AccessedClass;
import tel.schich.jniaccess.AccessedField;
import tel.schich.jniaccess.AccessedMethod;
import tel.schich.jniaccess.ConstructorCall;
import tel.schich.jniaccess.FieldWrapper;
import tel.schich.jniaccess.GeneratorHelper;
import tel.schich.jniaccess.JNIAccess;
import tel.schich.jniaccess.MethodCallWrapper;
import tel.schich.jniaccess.MethodParam;
import tel.schich.jniaccess.NativeInterfaceGenerator;
import tel.schich.jniaccess.NewInstanceWrapper;
import tel.schich.jniaccess.PerformanceCritical;
import tel.schich.jniaccess.ThrowWrapper;
import tel.schich.jniaccess.TypeHelper;
import tel.schich.jniaccess.WrappedElement;

public class JNIAccessProcessor
extends AbstractProcessor {
    private static final String OPTION_GENERATE_JNI_HEADERS = "generate.jni.headers";
    private static final String OPTION_OUTPUT_LOCATION = "output.location";
    private static final Set<String> SUPPORTED_ANNOTATIONS = Collections.singleton(JNIAccess.class.getCanonicalName());
    private static final Set<String> SUPPORTED_OPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("generate.jni.headers", "output.location")));

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return SUPPORTED_ANNOTATIONS;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.generateJavaToNativeInterface(roundEnv);
        return this.generateNativeToJavaInterface(roundEnv);
    }

    private boolean shouldGenerateJniHeaders() {
        return Boolean.parseBoolean(this.processingEnv.getOptions().getOrDefault(OPTION_GENERATE_JNI_HEADERS, "false"));
    }

    private File getOutputLocation() {
        String outputLocation = this.processingEnv.getOptions().get(OPTION_OUTPUT_LOCATION);
        if (outputLocation == null) {
            return null;
        }
        File file = new File(outputLocation);
        if (!file.exists() && !file.mkdirs()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        return file;
    }

    private void generateJavaToNativeInterface(RoundEnvironment roundEnv) {
        if (!this.shouldGenerateJniHeaders()) {
            return;
        }
        List<NativeInterfaceGenerator.ClassWithNatives> nativeMethods = NativeInterfaceGenerator.searchNativeMethods(roundEnv);
        if (nativeMethods.isEmpty()) {
            return;
        }
        String fileName = "jni-java-to-c";
        String headerGuard = "_JNI_JAVA_TO_C_INTERFACE";
        CharSequence headerContent = JNIAccessProcessor.generateHeader("_JNI_JAVA_TO_C_INTERFACE", out -> {
            JNIAccessProcessor.ifCpp(out, o -> o.append("extern \"C\" {\n"));
            nativeMethods.forEach(clazz -> {
                out.append("\n/* Begin Class: ").append(NativeInterfaceGenerator.buildFullyQualifiedElementName(clazz.getTheClass())).append(" */\n\n");
                for (VariableElement constant : clazz.getConstants()) {
                    this.generateConstant((StringBuilder)out, constant);
                    out.append('\n');
                    out.append('\n');
                }
                out.append('\n');
                List<ExecutableElement> methods = clazz.getMethods();
                HashMap<Name, Boolean> overloadedLookup = new HashMap<Name, Boolean>();
                for (ExecutableElement method : methods) {
                    Name methodName = method.getSimpleName();
                    overloadedLookup.put(methodName, overloadedLookup.containsKey(methodName));
                }
                for (ExecutableElement method : methods) {
                    this.generateExternPrototype((StringBuilder)out, method, overloadedLookup.getOrDefault(method.getSimpleName(), false));
                    out.append('\n');
                    out.append('\n');
                }
                out.append("/* End Class: ").append(NativeInterfaceGenerator.buildFullyQualifiedElementName(clazz.getTheClass())).append(" */\n\n");
            });
            JNIAccessProcessor.ifCpp(out, o -> o.append("}\n"));
        });
        this.writeNativeContent(headerContent, "jni-java-to-c.h");
    }

    private void generateConstant(StringBuilder out, VariableElement constant) {
        String cValue;
        String name = NativeInterfaceGenerator.buildFullyQualifiedElementName(constant).replace('.', '_');
        Object value = constant.getConstantValue();
        if (value instanceof Long) {
            cValue = value + "L";
        } else if (value instanceof Float) {
            cValue = value + "f";
        } else if (value instanceof Character) {
            char c = ((Character)value).charValue();
            cValue = "L'" + JNIAccessProcessor.escapeChar(c) + "'";
        } else {
            cValue = value instanceof String ? "L\"" + JNIAccessProcessor.escapeString((String)value) + "\"" : String.valueOf(value);
        }
        out.append("#define ").append(name).append(' ').append(cValue);
    }

    private static String escapeString(String s) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            out.append(JNIAccessProcessor.escapeChar(s.charAt(i)));
        }
        return out.toString();
    }

    private static String escapeChar(char c) {
        if (c == '\u0000') {
            return "\\0";
        }
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (Character.isISOControl(c)) {
            return "\\n" + c;
        }
        return String.valueOf(c);
    }

    private void generateExternPrototype(StringBuilder out, ExecutableElement method, boolean overloaded) {
        Types types = this.processingEnv.getTypeUtils();
        String name = JNIAccessProcessor.buildMangledName(types, method, overloaded);
        boolean instance = !method.getModifiers().contains((Object)Modifier.STATIC);
        List<MethodParam> params = JNIAccessProcessor.getParams(method);
        GeneratorHelper.generateExternFunctionSignature(this.processingEnv.getTypeUtils(), out, name, method.getReturnType(), instance, params);
    }

    private static String buildMangledName(Types types, ExecutableElement method, boolean overloaded) {
        String qualifiedName = NativeInterfaceGenerator.buildFullyQualifiedElementName(method);
        StringBuilder mangled = new StringBuilder();
        String[] segments = qualifiedName.split("\\.");
        mangled.append("Java");
        for (String segment : segments) {
            mangled.append('_');
            block6: for (int i = 0; i < segment.length(); ++i) {
                char c = segment.charAt(i);
                switch (c) {
                    case '_': {
                        mangled.append("_1");
                        continue block6;
                    }
                    case ';': {
                        mangled.append("_2");
                        continue block6;
                    }
                    case '[': {
                        mangled.append("_3");
                        continue block6;
                    }
                    default: {
                        if (Character.isLetterOrDigit(c)) {
                            mangled.append(c);
                            continue block6;
                        }
                        mangled.append("_0");
                        if (c < '\u0080') {
                            mangled.append(String.format("%04X", c));
                            continue block6;
                        }
                        mangled.append(String.format("%04x", c));
                    }
                }
            }
        }
        if (overloaded) {
            mangled.append("__");
            GeneratorHelper.generateJniMethodParametersSignature(mangled, types, JNIAccessProcessor.getParams(method));
        }
        return mangled.toString();
    }

    private boolean generateNativeToJavaInterface(RoundEnvironment roundEnv) {
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(JNIAccess.class);
        ArrayList<WrappedElement> wrappedElements = new ArrayList<WrappedElement>();
        for (Element element : annotatedElements) {
            boolean performanceCritical = element.getAnnotation(PerformanceCritical.class) != null;
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    wrappedElements.add(this.processConstructor(element, performanceCritical));
                    break;
                }
                case METHOD: {
                    wrappedElements.add(this.processMethod(element, performanceCritical));
                    break;
                }
                case FIELD: {
                    wrappedElements.add(this.processField(element, performanceCritical));
                    break;
                }
            }
        }
        if (wrappedElements.isEmpty()) {
            return false;
        }
        String fileName = "jni-c-to-java";
        String string = "_JNI_C_TO_JAVA_INTERFACE";
        CharSequence headerContent = JNIAccessProcessor.generateHeader("_JNI_C_TO_JAVA_INTERFACE", headerOutput -> {
            for (WrappedElement e : wrappedElements) {
                e.generateDeclarations((StringBuilder)headerOutput);
            }
        });
        String generatedHeaderName = "jni-c-to-java.h";
        this.writeNativeContent(headerContent, "jni-c-to-java.h");
        StringBuilder implementationOutput = new StringBuilder();
        implementationOutput.append("#include \"").append("jni-c-to-java.h").append("\"\n");
        implementationOutput.append("\n");
        for (WrappedElement e : wrappedElements) {
            e.generateImplementations(implementationOutput);
        }
        this.writeNativeContent(implementationOutput, "jni-c-to-java.c");
        return true;
    }

    private static CharSequence generateHeader(String headerGuard, Consumer<StringBuilder> builder) {
        StringBuilder out = new StringBuilder();
        out.append("#ifndef ").append(headerGuard).append("\n");
        out.append("#define ").append(headerGuard).append("\n\n");
        out.append("#include <jni.h>\n");
        out.append("\n");
        builder.accept(out);
        out.append("\n");
        out.append("#endif\n");
        return out;
    }

    private static void ifCpp(StringBuilder out, Consumer<StringBuilder> builder) {
        out.append("#ifdef __cplusplus\n");
        builder.accept(out);
        out.append("#endif\n");
    }

    private Writer openFile(String file) throws IOException {
        FileObject resource = null;
        try {
            resource = this.processingEnv.getFiler().createResource(StandardLocation.NATIVE_HEADER_OUTPUT, "", file, new Element[0]);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (resource != null) {
            return resource.openWriter();
        }
        File outputLocation = this.getOutputLocation();
        if (outputLocation != null) {
            return new FileWriter(new File(outputLocation, file), false);
        }
        return null;
    }

    private void writeNativeContent(CharSequence out, String file) {
        try (Writer writer = this.openFile(file);){
            if (writer == null) {
                this.logError("No output location available! You can use the 'output.location' argument to set one or use the -h option of javac (1.8+).");
                return;
            }
            writer.write(out.toString());
        }
        catch (IOException e) {
            this.logError(e.getLocalizedMessage());
        }
    }

    private WrappedElement processConstructor(Element element, boolean performanceCritical) {
        TypeElement clazz = (TypeElement)element.getEnclosingElement();
        ExecutableElement ctor = (ExecutableElement)element;
        Types typeUtils = this.processingEnv.getTypeUtils();
        ConstructorCall call = new ConstructorCall(new AccessedClass(clazz, clazz.asType()), new AccessedMethod(ctor, JNIAccessProcessor.getParams(ctor)));
        if (TypeHelper.isInstanceOf(typeUtils, clazz.asType(), Throwable.class)) {
            return new ThrowWrapper(typeUtils, performanceCritical, call);
        }
        return new NewInstanceWrapper(typeUtils, performanceCritical, call);
    }

    private WrappedElement processMethod(Element element, boolean performanceCritical) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement clazz = (TypeElement)element.getEnclosingElement();
        ExecutableElement method = (ExecutableElement)element;
        return new MethodCallWrapper(typeUtils, performanceCritical, new AccessedClass(clazz, clazz.asType()), new AccessedMethod(method, JNIAccessProcessor.getParams(method)));
    }

    private WrappedElement processField(Element element, boolean performanceCritical) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement clazz = (TypeElement)element.getEnclosingElement();
        VariableElement field = (VariableElement)element;
        return new FieldWrapper(typeUtils, performanceCritical, new AccessedClass(clazz, clazz.asType()), new AccessedField(field, field.asType()));
    }

    private void logError(String s) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, s);
    }

    private static List<MethodParam> getParams(ExecutableElement element) {
        ArrayList<MethodParam> params = new ArrayList<MethodParam>();
        for (VariableElement variableElement : element.getParameters()) {
            params.add(new MethodParam(variableElement.getSimpleName().toString(), variableElement, variableElement.asType()));
        }
        return params;
    }
}

