/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.jniaccess;

import javax.lang.model.util.Types;
import tel.schich.jniaccess.AccessedClass;
import tel.schich.jniaccess.AccessedMethod;
import tel.schich.jniaccess.GeneratorHelper;
import tel.schich.jniaccess.MethodBackedWrapper;
import tel.schich.jniaccess.MethodParam;
import tel.schich.jniaccess.TypeHelper;

public class MethodCallWrapper
extends MethodBackedWrapper {
    private final AccessedClass clazz;
    private final AccessedMethod method;

    public MethodCallWrapper(Types types, boolean performanceCritical, AccessedClass clazz, AccessedMethod method) {
        super(types, performanceCritical, method);
        this.clazz = clazz;
        this.method = method;
    }

    @Override
    protected String generateFunctionName() {
        return GeneratorHelper.functionName("call", this.clazz, this.method.getName());
    }

    @Override
    protected void generateImpl(StringBuilder out) {
        this.generateSig(out, false);
        out.append(" {\n");
        GeneratorHelper.generateClassLookup(out, "class", this.clazz, "    ");
        out.append('\n');
        out.append("    jmethodID method = (*env)->Get");
        if (this.method.isStatic()) {
            out.append("Static");
        }
        out.append("MethodID(env, class, \"");
        out.append(this.method.getName()).append("\", \"");
        GeneratorHelper.generateJniMethodSignature(out, this.getTypes(), this.method);
        out.append("\");\n");
        out.append("    return (*env)->Call");
        if (this.method.isStatic()) {
            out.append("Static");
        }
        out.append(TypeHelper.getJNIHelperType(this.method.getElement().getReturnType()));
        out.append("Method(env, ");
        out.append(this.method.isStatic() ? "class" : "instance");
        out.append(", method");
        for (MethodParam param : this.method.getParams()) {
            out.append(", ").append(param.getName());
        }
        out.append(");\n");
        out.append("}\n");
    }
}

