/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.jniaccess;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.VariableElement;

public class NativeInterfaceGenerator {
    public static List<ClassWithNatives> searchNativeMethods(RoundEnvironment roundEnv) {
        ArrayList<ClassWithNatives> methods = new ArrayList<ClassWithNatives>();
        for (Element element : roundEnv.getRootElements()) {
            methods.addAll(NativeInterfaceGenerator.searchNativeMethods(element));
        }
        return methods;
    }

    public static ArrayList<ClassWithNatives> searchNativeMethods(Element element) {
        ArrayList<ClassWithNatives> accumulator = new ArrayList<ClassWithNatives>();
        NativeInterfaceGenerator.searchNativeMethods(element, accumulator);
        return accumulator;
    }

    private static void searchNativeMethods(Element element, List<ClassWithNatives> accumulator) {
        switch (element.getKind()) {
            case CLASS: 
            case ENUM: {
                ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
                ArrayList<VariableElement> constants = new ArrayList<VariableElement>();
                for (Element element2 : element.getEnclosedElements()) {
                    if (element2.getKind() == ElementKind.METHOD) {
                        ExecutableElement executable = (ExecutableElement)element2;
                        if (!executable.getModifiers().contains((Object)Modifier.NATIVE)) continue;
                        methods.add(executable);
                        continue;
                    }
                    if (element2.getKind() == ElementKind.FIELD) {
                        VariableElement variable = (VariableElement)element2;
                        Set<Modifier> modifiers = variable.getModifiers();
                        if (!modifiers.contains((Object)Modifier.FINAL) || !modifiers.contains((Object)Modifier.STATIC) || variable.getConstantValue() == null) continue;
                        constants.add(variable);
                        continue;
                    }
                    NativeInterfaceGenerator.searchNativeMethods(element2, accumulator);
                }
                if (methods.size() + constants.size() <= 0) break;
                accumulator.add(new ClassWithNatives(element, methods, constants));
            }
        }
    }

    public static String buildFullyQualifiedElementName(Element element) {
        if (element instanceof QualifiedNameable) {
            return ((QualifiedNameable)element).getQualifiedName().toString();
        }
        Element enclosing = element.getEnclosingElement();
        String prefix = enclosing != null ? NativeInterfaceGenerator.buildFullyQualifiedElementName(enclosing) + "." : "";
        return prefix + element.getSimpleName().toString();
    }

    public static class ClassWithNatives {
        private final Element theClass;
        private final List<ExecutableElement> methods;
        private final List<VariableElement> constants;

        public ClassWithNatives(Element theClass, List<ExecutableElement> methods, List<VariableElement> constants) {
            this.theClass = theClass;
            this.methods = methods;
            this.constants = constants;
        }

        public Element getTheClass() {
            return this.theClass;
        }

        public List<ExecutableElement> getMethods() {
            return this.methods;
        }

        public List<VariableElement> getConstants() {
            return this.constants;
        }
    }
}

