/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.jniaccess;

import java.util.List;
import javax.lang.model.util.Types;
import tel.schich.jniaccess.AccessedMethod;
import tel.schich.jniaccess.ConstructorCall;
import tel.schich.jniaccess.GeneratorHelper;
import tel.schich.jniaccess.MethodBackedWrapper;
import tel.schich.jniaccess.MethodParam;
import tel.schich.jniaccess.TypeHelper;

public class ThrowWrapper
extends MethodBackedWrapper {
    private final ConstructorCall constructor;

    public ThrowWrapper(Types types, boolean performanceCritical, ConstructorCall constructor) {
        super(types, performanceCritical, constructor.getMethod());
        this.constructor = constructor;
    }

    @Override
    protected String generateFunctionName() {
        return GeneratorHelper.functionName("throw", this.constructor.getClazz());
    }

    @Override
    protected void generateImpl(StringBuilder out) {
        this.generateSig(out, false);
        out.append(" {\n");
        GeneratorHelper.generateClassLookup(out, "class", this.constructor.getClazz(), "    ");
        out.append('\n');
        AccessedMethod method = this.constructor.getMethod();
        List<MethodParam> params = method.getParams();
        if (params.size() == 1 && TypeHelper.isString(this.getTypes(), params.get(0).getType())) {
            out.append("    (*env)->ThrowNew(env, class, ").append(params.get(0).getName()).append(");\n");
        } else {
            GeneratorHelper.generateMethodLookup(this.getTypes(), out, "ctor", "class", method, "    ");
            out.append('\n');
            out.append("    jthrowable t = ");
            GeneratorHelper.generateNewObjectCreation(out, "class", "ctor", method);
            out.append('\n');
            out.append("    (*env)->Throw(env, t);\n");
        }
        out.append("}\n");
    }
}

