/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.jniaccess;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public abstract class TypeHelper {
    private TypeHelper() {
    }

    static boolean isInstanceOf(Types typeUtils, TypeMirror haystack, Class<?> needle) {
        Element element = typeUtils.asElement(haystack);
        if (!(element instanceof TypeElement)) {
            return false;
        }
        if (((TypeElement)element).getQualifiedName().toString().equals(needle.getName())) {
            return true;
        }
        for (TypeMirror typeMirror : typeUtils.directSupertypes(haystack)) {
            if (!(typeMirror instanceof DeclaredType)) continue;
            return TypeHelper.isInstanceOf(typeUtils, typeMirror, needle);
        }
        return false;
    }

    static boolean isString(Types typeUtils, TypeMirror type) {
        return TypeHelper.isInstanceOf(typeUtils, type, String.class);
    }

    static String getJNIType(Types typeUtils, TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return "Z";
            }
            case CHAR: {
                return "C";
            }
            case BYTE: {
                return "B";
            }
            case SHORT: {
                return "S";
            }
            case INT: {
                return "I";
            }
            case LONG: {
                return "J";
            }
            case FLOAT: {
                return "F";
            }
            case DOUBLE: {
                return "D";
            }
            case VOID: {
                return "V";
            }
            case DECLARED: {
                TypeElement elem = (TypeElement)typeUtils.asElement(type);
                return "L" + elem.getQualifiedName().toString().replace('.', '/') + ";";
            }
            case ARRAY: {
                return "[" + TypeHelper.getJNIType(typeUtils, ((ArrayType)type).getComponentType());
            }
        }
        throw new IllegalArgumentException("Unsupported type!");
    }

    static String getJNIHelperType(TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return "Boolean";
            }
            case CHAR: {
                return "Char";
            }
            case BYTE: {
                return "Byte";
            }
            case SHORT: {
                return "Short";
            }
            case INT: {
                return "Int";
            }
            case LONG: {
                return "Long";
            }
            case FLOAT: {
                return "Float";
            }
            case DOUBLE: {
                return "Double";
            }
        }
        return "Object";
    }

    static String getCType(Types typeUtils, TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return "jboolean";
            }
            case CHAR: {
                return "jchar";
            }
            case BYTE: {
                return "jbyte";
            }
            case SHORT: {
                return "jshort";
            }
            case INT: {
                return "jint";
            }
            case LONG: {
                return "jlong";
            }
            case FLOAT: {
                return "jfloat";
            }
            case DOUBLE: {
                return "jdouble";
            }
            case VOID: {
                return "void";
            }
            case ARRAY: {
                switch (((ArrayType)type).getComponentType().getKind()) {
                    case BOOLEAN: {
                        return "jbooleanArray";
                    }
                    case CHAR: {
                        return "jcharArray";
                    }
                    case BYTE: {
                        return "jbyteArray";
                    }
                    case SHORT: {
                        return "jshortArray";
                    }
                    case INT: {
                        return "jintArray";
                    }
                    case LONG: {
                        return "jlongArray";
                    }
                    case FLOAT: {
                        return "jfloatArray";
                    }
                    case DOUBLE: {
                        return "jdoubleArray";
                    }
                }
                return "jobjectArray";
            }
        }
        if (TypeHelper.isInstanceOf(typeUtils, type, String.class)) {
            return "jstring";
        }
        if (TypeHelper.isInstanceOf(typeUtils, type, Throwable.class)) {
            return "jthrowable";
        }
        return "jobject";
    }

    public static TypeMirror getVoid(Types types) {
        return types.getNoType(TypeKind.VOID);
    }
}

