/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import tel.schich.libdatachannel.DataChannelCallback;
import tel.schich.libdatachannel.DataChannelReliability;
import tel.schich.libdatachannel.EventListenerContainer;
import tel.schich.libdatachannel.LibDataChannelNative;
import tel.schich.libdatachannel.PeerConnection;
import tel.schich.libdatachannel.Util;

public class DataChannel
implements Closeable {
    private final PeerConnection peer;
    final int channelHandle;
    public final EventListenerContainer<DataChannelCallback.Open> onOpen;
    public final EventListenerContainer<DataChannelCallback.Closed> onClosed;
    public final EventListenerContainer<DataChannelCallback.Error> onError;
    public final EventListenerContainer<DataChannelCallback.Message> onMessage;
    public final EventListenerContainer<DataChannelCallback.BufferedAmountLow> onBufferedAmountLow;
    public final EventListenerContainer<DataChannelCallback.Available> onAvailable;

    DataChannel(PeerConnection peer, int channelHandle, Executor executor) {
        this.peer = peer;
        this.channelHandle = channelHandle;
        this.onOpen = new EventListenerContainer("ChannelOpen", set -> LibDataChannelNative.rtcSetOpenCallback(channelHandle, set), executor);
        this.onClosed = new EventListenerContainer("ChannelClosed", set -> LibDataChannelNative.rtcSetClosedCallback(channelHandle, set), executor);
        this.onError = new EventListenerContainer("ChannelError", set -> LibDataChannelNative.rtcSetErrorCallback(channelHandle, set), executor);
        this.onMessage = new EventListenerContainer("ChannelMessage", set -> LibDataChannelNative.rtcSetMessageCallback(channelHandle, set), executor);
        this.onBufferedAmountLow = new EventListenerContainer("ChannelBufferedAmountLow", set -> LibDataChannelNative.rtcSetBufferedAmountLowCallback(channelHandle, set), executor);
        this.onAvailable = new EventListenerContainer("ChannelAvailable", set -> LibDataChannelNative.rtcSetAvailableCallback(channelHandle, set), executor);
    }

    public PeerConnection peer() {
        return this.peer;
    }

    private void sendMessage(ByteBuffer data, int offset, int length) {
        Util.wrapError("sendMessage", LibDataChannelNative.rtcSendMessage(this.channelHandle, data, offset, length));
    }

    public void sendMessage(ByteBuffer data) {
        Util.ensureDirect(data);
        this.sendMessage(data, data.position(), data.remaining());
    }

    public void sendMessage(String message) {
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        ByteBuffer data = ByteBuffer.allocateDirect(bytes.length + 1);
        data.put(bytes);
        data.put((byte)0);
        data.flip();
        this.sendMessage(data, data.position(), -1);
    }

    @Override
    public void close() {
        if (LibDataChannelNative.rtcClose(this.channelHandle) != -1) {
            LibDataChannelNative.rtcDeleteDataChannel(this.channelHandle);
        }
        this.peer.dropChannelState(this.channelHandle);
        this.onOpen.close();
        this.onClosed.close();
        this.onError.close();
        this.onMessage.close();
        this.onBufferedAmountLow.close();
        this.onAvailable.close();
    }

    public boolean isClosed() {
        return LibDataChannelNative.rtcIsClosed(this.channelHandle);
    }

    public boolean isOpen() {
        return LibDataChannelNative.rtcIsOpen(this.channelHandle);
    }

    public int maxMessageSize() {
        return Util.wrapError("rtcMaxMessageSize", LibDataChannelNative.rtcMaxMessageSize(this.channelHandle));
    }

    public void bufferedAmountLowThreshold(int amount) {
        Util.wrapError("rtcSetBufferedAmountLowThreshold", LibDataChannelNative.rtcSetBufferedAmountLowThreshold(this.channelHandle, amount));
    }

    public Optional<ByteBuffer> receiveMessage() {
        return Optional.ofNullable(LibDataChannelNative.rtcReceiveMessage(this.channelHandle));
    }

    public int receiveMessage(ByteBuffer buffer) {
        Util.ensureDirect(buffer);
        return LibDataChannelNative.rtcReceiveMessageInto(this.channelHandle, buffer, buffer.position(), buffer.remaining());
    }

    public int availableAmount() {
        return Util.wrapError("rtcGetAvailableAmount", LibDataChannelNative.rtcGetAvailableAmount(this.channelHandle));
    }

    public int bufferedAmount() {
        return Util.wrapError("rtcGetBufferedAmount", LibDataChannelNative.rtcGetBufferedAmount(this.channelHandle));
    }

    public int streamId() {
        return Util.wrapError("rtcGetDataChannelStream", LibDataChannelNative.rtcGetDataChannelStream(this.channelHandle));
    }

    public String label() {
        return LibDataChannelNative.rtcGetDataChannelLabel(this.channelHandle);
    }

    public String protocol() {
        return LibDataChannelNative.rtcGetDataChannelProtocol(this.channelHandle);
    }

    public DataChannelReliability reliability() {
        return LibDataChannelNative.rtcGetDataChannelReliability(this.channelHandle);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataChannel)) {
            return false;
        }
        DataChannel channel = (DataChannel)o;
        return this.channelHandle == channel.channelHandle;
    }

    public int hashCode() {
        return Objects.hashCode(this.channelHandle);
    }
}

