/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.nio.ByteBuffer;
import tel.schich.libdatachannel.DataChannel;

public interface DataChannelCallback {

    @FunctionalInterface
    public static interface Available {
        public void onAvailable(DataChannel var1);
    }

    @FunctionalInterface
    public static interface BufferedAmountLow {
        public void onBufferedAmountLow(DataChannel var1);
    }

    @FunctionalInterface
    public static interface BinaryMessage {
        public void onBinary(DataChannel var1, ByteBuffer var2);
    }

    @FunctionalInterface
    public static interface TextMessage {
        public void onText(DataChannel var1, String var2);
    }

    public static interface Message
    extends TextMessage,
    BinaryMessage {
        public static Message handleText(final TextMessage handler) {
            return new Message(){

                @Override
                public void onText(DataChannel channel, String text) {
                    handler.onText(channel, text);
                }

                @Override
                public void onBinary(DataChannel channel, ByteBuffer buffer) {
                }
            };
        }

        public static Message handleBinary(final BinaryMessage handler) {
            return new Message(){

                @Override
                public void onText(DataChannel channel, String text) {
                }

                @Override
                public void onBinary(DataChannel channel, ByteBuffer buffer) {
                    handler.onBinary(channel, buffer);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Error {
        public void onError(DataChannel var1, String var2);
    }

    @FunctionalInterface
    public static interface Closed {
        public void onClosed(DataChannel var1);
    }

    @FunctionalInterface
    public static interface Open {
        public void onOpen(DataChannel var1);
    }
}

