/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.util.Optional;
import java.util.OptionalInt;
import org.eclipse.jdt.annotation.Nullable;
import tel.schich.libdatachannel.DataChannelReliability;

public class DataChannelInitSettings {
    public static final DataChannelInitSettings DEFAULT = new DataChannelInitSettings(DataChannelReliability.DEFAULT, null, false, null);
    private final DataChannelReliability reliability;
    private final @Nullable String protocol;
    private final boolean negotiated;
    private final @Nullable Integer stream;

    private DataChannelInitSettings(DataChannelReliability reliability, @Nullable String protocol, boolean negotiated, @Nullable Integer stream) {
        this.reliability = reliability;
        this.protocol = protocol;
        this.negotiated = negotiated;
        this.stream = stream;
    }

    public DataChannelReliability reliability() {
        return this.reliability;
    }

    public DataChannelInitSettings withReliability(DataChannelReliability reliability) {
        return new DataChannelInitSettings(reliability, this.protocol, this.negotiated, this.stream);
    }

    public DataChannelInitSettings withProtocol(String protocol) {
        return new DataChannelInitSettings(this.reliability, protocol, this.negotiated, this.stream);
    }

    public Optional<String> protocol() {
        return Optional.ofNullable(this.protocol);
    }

    public DataChannelInitSettings withNegotiated(boolean negotiated) {
        return new DataChannelInitSettings(this.reliability, this.protocol, negotiated, this.stream);
    }

    public boolean isNegotiated() {
        return this.negotiated;
    }

    public DataChannelInitSettings withStream(Integer stream) {
        return new DataChannelInitSettings(this.reliability, this.protocol, this.negotiated, stream);
    }

    public OptionalInt stream() {
        if (this.stream == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.stream);
    }
}

