/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.time.Duration;

public class DataChannelReliability {
    public static final DataChannelReliability DEFAULT = new DataChannelReliability(false, false, 0L, 0);
    private final boolean unordered;
    private final boolean unreliable;
    private final long maxPacketLifeTime;
    private final int maxRetransmits;

    public DataChannelReliability(boolean unordered, boolean unreliable, long maxPacketLifeTime, int maxRetransmits) {
        this.unordered = unordered;
        this.unreliable = unreliable;
        this.maxPacketLifeTime = maxPacketLifeTime;
        this.maxRetransmits = maxRetransmits;
    }

    public boolean isUnordered() {
        return this.unordered;
    }

    public DataChannelReliability withUnordered(boolean unordered) {
        return new DataChannelReliability(unordered, unordered, this.maxPacketLifeTime, this.maxRetransmits);
    }

    public boolean isUnreliable() {
        return this.unreliable;
    }

    public DataChannelReliability withUnreliable(boolean unreliable) {
        return new DataChannelReliability(this.unordered, unreliable, this.maxPacketLifeTime, this.maxRetransmits);
    }

    public Duration maxPacketLifeTime() {
        return Duration.ofMillis(this.maxPacketLifeTime);
    }

    public DataChannelReliability withMaxPacketLifeTime(Duration maxPacketLifeTime) {
        return new DataChannelReliability(this.unordered, this.unordered, maxPacketLifeTime.toMillis(), this.maxRetransmits);
    }

    public int maxRetransmits() {
        return this.maxRetransmits;
    }

    public DataChannelReliability withMaxRetransmits(int maxRetransmits) {
        return new DataChannelReliability(this.unordered, this.unordered, this.maxPacketLifeTime, maxRetransmits);
    }
}

