/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerContainer<T>
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventListenerContainer.class);
    private final String eventName;
    private final Consumer<Boolean> lifecycleCallback;
    private final List<T> listeners;
    private final Lock changeLock;
    private final Executor executor;
    private volatile boolean closed;

    public EventListenerContainer(String eventName, Consumer<Boolean> lifecycleCallback, Executor executor) {
        this.eventName = eventName;
        this.lifecycleCallback = lifecycleCallback;
        this.listeners = new CopyOnWriteArrayList<T>();
        this.changeLock = new ReentrantLock();
        this.executor = executor;
        this.closed = false;
    }

    public String eventName() {
        return this.eventName;
    }

    void invoke(Consumer<T> invoker) {
        if (this.closed) {
            LOGGER.warn("Invoke attempted on closed container for event {}", (Object)this.eventName);
            return;
        }
        this.executor.execute(() -> {
            for (T listener : this.listeners) {
                try {
                    invoker.accept(listener);
                }
                catch (Throwable t) {
                    LOGGER.error("Handler for event {} failed!", (Object)this.eventName, (Object)t);
                }
            }
        });
    }

    public void register(T listener) {
        boolean wasEmpty;
        this.changeLock.lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("Container for event " + this.eventName + " is already closed!");
            }
            wasEmpty = this.listeners.isEmpty();
            this.listeners.add(listener);
        }
        finally {
            this.changeLock.unlock();
        }
        if (wasEmpty) {
            this.lifecycleCallback.accept(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deregister(T listener) {
        boolean isNowEmpty;
        this.changeLock.lock();
        try {
            if (!this.listeners.remove(listener)) {
                boolean bl = false;
                return bl;
            }
            isNowEmpty = this.listeners.isEmpty();
        }
        finally {
            this.changeLock.unlock();
        }
        if (isNowEmpty) {
            this.lifecycleCallback.accept(false);
        }
        return true;
    }

    private boolean internalDeregisterAll() {
        this.changeLock.lock();
        try {
            if (this.closed) {
                boolean bl = false;
                return bl;
            }
            boolean triggerLifecycleCallback = !this.listeners.isEmpty();
            this.listeners.clear();
            boolean bl = triggerLifecycleCallback;
            return bl;
        }
        finally {
            this.changeLock.unlock();
        }
    }

    public void deregisterAll() {
        if (this.internalDeregisterAll()) {
            this.lifecycleCallback.accept(false);
        }
    }

    @Override
    public void close() {
        boolean triggerLifecycleCallback;
        this.changeLock.lock();
        try {
            if (this.closed) {
                return;
            }
            triggerLifecycleCallback = this.internalDeregisterAll();
            this.closed = true;
        }
        finally {
            this.changeLock.unlock();
        }
        if (triggerLifecycleCallback) {
            this.lifecycleCallback.accept(false);
        }
    }

    public String toString() {
        return this.eventName;
    }
}

