/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.lang.ref.Cleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tel.schich.libdatachannel.Platform;

public class LibDataChannel {
    static final Cleaner CLEANER = Cleaner.create();
    private static final Logger LOGGER = LoggerFactory.getLogger(LibDataChannel.class);
    private static volatile boolean initialized = false;
    public static final String LIB_NAME = "datachannel-java";

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        Platform.loadNativeLibrary(LIB_NAME, LibDataChannel.class);
        initialized = true;
    }

    static void log(int level, String message) {
        switch (level) {
            case 1: 
            case 2: {
                LOGGER.error(message);
                return;
            }
            case 3: {
                LOGGER.warn(message);
                return;
            }
            case 4: {
                LOGGER.info(message);
                return;
            }
            case 5: {
                LOGGER.debug(message);
                return;
            }
            case 6: {
                LOGGER.trace(message);
            }
        }
    }

    private static void freeOnGarbageCollection(Object owner, long nativeAddress) {
        CLEANER.register(owner, () -> LibDataChannel.freeMemory(nativeAddress));
    }

    private static native void freeMemory(long var0);
}

