/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.io.Closeable;
import java.lang.ref.Cleaner;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tel.schich.libdatachannel.CandidatePair;
import tel.schich.libdatachannel.DataChannel;
import tel.schich.libdatachannel.DataChannelInitSettings;
import tel.schich.libdatachannel.DataChannelReliability;
import tel.schich.libdatachannel.EventListenerContainer;
import tel.schich.libdatachannel.LibDataChannel;
import tel.schich.libdatachannel.LibDataChannelNative;
import tel.schich.libdatachannel.PeerConnectionCallback;
import tel.schich.libdatachannel.PeerConnectionConfiguration;
import tel.schich.libdatachannel.PeerConnectionListener;
import tel.schich.libdatachannel.SessionDescriptionType;
import tel.schich.libdatachannel.Track;
import tel.schich.libdatachannel.TrackInit;
import tel.schich.libdatachannel.Util;

public class PeerConnection
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerConnection.class);
    final int peerHandle;
    private final Executor executor;
    private final ConcurrentMap<Integer, DataChannel> channels;
    private final ConcurrentMap<Integer, Track> tracks;
    private final Cleaner.Cleanable cleanable;
    final PeerConnectionListener listener;
    public final EventListenerContainer<PeerConnectionCallback.LocalDescription> onLocalDescription;
    public final EventListenerContainer<PeerConnectionCallback.LocalCandidate> onLocalCandidate;
    public final EventListenerContainer<PeerConnectionCallback.StateChange> onStateChange;
    public final EventListenerContainer<PeerConnectionCallback.IceStateChange> onIceStateChange;
    public final EventListenerContainer<PeerConnectionCallback.GatheringStateChange> onGatheringStateChange;
    public final EventListenerContainer<PeerConnectionCallback.SignalingStateChange> onSignalingStateChange;
    public final EventListenerContainer<PeerConnectionCallback.DataChannel> onDataChannel;
    public final EventListenerContainer<PeerConnectionCallback.Track> onTrack;

    private PeerConnection(int peerHandle, Executor executor) {
        this.peerHandle = peerHandle;
        this.executor = executor;
        this.channels = new ConcurrentHashMap<Integer, DataChannel>();
        this.tracks = new ConcurrentHashMap<Integer, Track>();
        this.listener = new PeerConnectionListener(this);
        this.onLocalDescription = new EventListenerContainer("LocalDescription", set -> LibDataChannelNative.rtcSetLocalDescriptionCallback(peerHandle, set), executor);
        this.onLocalCandidate = new EventListenerContainer("LocalCandidate", set -> LibDataChannelNative.rtcSetLocalCandidateCallback(peerHandle, set), executor);
        this.onStateChange = new EventListenerContainer("StateChange", set -> LibDataChannelNative.rtcSetStateChangeCallback(peerHandle, set), executor);
        this.onIceStateChange = new EventListenerContainer("IceStateChange", set -> LibDataChannelNative.rtcSetIceStateChangeCallback(peerHandle, set), executor);
        this.onGatheringStateChange = new EventListenerContainer("GatheringStateChange", set -> LibDataChannelNative.rtcSetGatheringStateChangeCallback(peerHandle, set), executor);
        this.onSignalingStateChange = new EventListenerContainer("SignalingStateChange", set -> LibDataChannelNative.rtcSetSignalingStateChangeCallback(peerHandle, set), executor);
        this.onDataChannel = new EventListenerContainer("DataChannel", set -> LibDataChannelNative.rtcSetDataChannelCallback(peerHandle, set), executor);
        this.onTrack = new EventListenerContainer("Track", set -> LibDataChannelNative.rtcSetTrackCallback(peerHandle, set), executor);
        this.cleanable = LibDataChannel.CLEANER.register(this, () -> {
            if (LibDataChannelNative.rtcClosePeerConnection(peerHandle) != -1) {
                LibDataChannelNative.rtcDeletePeerConnection(peerHandle);
            }
        });
    }

    private static String @Nullable [] iceUrisToStrings(@Nullable Collection<URI> uris) {
        if (uris == null || uris.isEmpty()) {
            return null;
        }
        int index = 0;
        String[] strings = new String[uris.size()];
        for (URI server : uris) {
            strings[index++] = server.toASCIIString();
        }
        return strings;
    }

    public static PeerConnection createPeer(PeerConnectionConfiguration config, Executor executor) {
        String proxyServer = null;
        if (config.proxyServer != null) {
            proxyServer = config.proxyServer.toASCIIString();
        }
        String bindAddress = null;
        if (config.bindAddress != null) {
            bindAddress = config.bindAddress.toString();
        }
        int result = LibDataChannelNative.rtcCreatePeerConnection(PeerConnection.iceUrisToStrings(config.iceServers), proxyServer, bindAddress, config.certificateType.state, config.iceTransportPolicy.state, config.enableIceTcp, config.enableIceUdpMux, config.disableAutoNegotiation, config.forceMediaTransport, config.portRangeBegin, config.portRangeEnd, config.mtu, config.maxMessageSize);
        PeerConnection peer = new PeerConnection(Util.wrapError("rtcCreatePeerConnection", result), executor);
        LibDataChannelNative.setupPeerConnectionListener(peer.peerHandle, peer.listener);
        return peer;
    }

    public static PeerConnection createPeer(PeerConnectionConfiguration config) {
        return PeerConnection.createPeer(config, Runnable::run);
    }

    @Nullable DataChannel channel(int channelHandle) {
        return (DataChannel)this.channels.get(channelHandle);
    }

    DataChannel newChannel(int channelHandle) {
        return this.channels.computeIfAbsent(channelHandle, h -> new DataChannel(this, (int)h, this.executor));
    }

    void dropChannelState(int channelHandle) {
        this.channels.remove(channelHandle);
    }

    Track newTrack(int trackHandle) {
        return this.tracks.computeIfAbsent(trackHandle, h -> new Track(this, (int)h));
    }

    public void dropTrackState(int trackHandle) {
        this.tracks.remove(trackHandle);
    }

    @Override
    public void close() {
        try {
            this.closeChannels();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to close channels of peer connection", (Throwable)e);
        }
        this.cleanable.clean();
        this.onLocalDescription.close();
        this.onLocalCandidate.close();
        this.onStateChange.close();
        this.onIceStateChange.close();
        this.onGatheringStateChange.close();
        this.onSignalingStateChange.close();
        this.onDataChannel.close();
        this.onTrack.close();
    }

    public void closeChannels() {
        for (DataChannel ch : new ArrayList(this.channels.values())) {
            ch.close();
        }
        if (!this.channels.isEmpty()) {
            this.closeChannels();
        }
    }

    public void setLocalDescription(String type) {
        Util.wrapError("rtcSetLocalDescription", LibDataChannelNative.rtcSetLocalDescription(this.peerHandle, type));
    }

    public String localDescription() {
        return LibDataChannelNative.rtcGetLocalDescription(this.peerHandle);
    }

    public String localDescriptionType() {
        return LibDataChannelNative.rtcGetLocalDescriptionType(this.peerHandle);
    }

    public void setRemoteDescription(String sdp, @Nullable SessionDescriptionType type) {
        String typeString = null;
        if (type != null) {
            typeString = type.type;
        }
        Util.wrapError("rtcSetRemoteDescription", LibDataChannelNative.rtcSetRemoteDescription(this.peerHandle, sdp, typeString));
    }

    public String remoteDescription() {
        return LibDataChannelNative.rtcGetRemoteDescription(this.peerHandle);
    }

    public @Nullable SessionDescriptionType remoteDescriptionType() {
        return SessionDescriptionType.of(LibDataChannelNative.rtcGetRemoteDescriptionType(this.peerHandle));
    }

    public void addRemoteCandidate(String candidate) {
        this.addRemoteCandidate(candidate, null);
    }

    public void addRemoteCandidate(String candidate, @Nullable String mediaId) {
        Util.wrapError("rtcAddRemoteCandidate", LibDataChannelNative.rtcAddRemoteCandidate(this.peerHandle, candidate, mediaId));
    }

    public InetSocketAddress localAddress() {
        return Util.parseAddress(LibDataChannelNative.rtcGetLocalAddress(this.peerHandle));
    }

    public InetSocketAddress remoteAddress() {
        return Util.parseAddress(LibDataChannelNative.rtcGetRemoteAddress(this.peerHandle));
    }

    public CandidatePair selectedCandidatePair() {
        return LibDataChannelNative.rtcGetSelectedCandidatePair(this.peerHandle);
    }

    public int maxDataChannelStream() {
        return LibDataChannelNative.rtcGetMaxDataChannelStream(this.peerHandle);
    }

    public int remoteMaxMessageSize() {
        return LibDataChannelNative.rtcGetRemoteMaxMessageSize(this.peerHandle);
    }

    public void setAnswer(String sdp) {
        this.setRemoteDescription(sdp, SessionDescriptionType.ANSWER);
    }

    public DataChannel createDataChannel(String label) {
        return this.createDataChannel(label, DataChannelInitSettings.DEFAULT);
    }

    public DataChannel createDataChannel(String label, DataChannelInitSettings init) {
        DataChannelReliability reliability = init.reliability();
        int stream = init.stream().orElse(0);
        boolean manualStream = init.stream().isPresent();
        int channelHandle = Util.wrapError("rtcCreateDataChannelEx", LibDataChannelNative.rtcCreateDataChannelEx(this.peerHandle, label, reliability.isUnordered(), reliability.isUnreliable(), reliability.maxPacketLifeTime().toMillis(), reliability.maxRetransmits(), init.protocol().orElse(null), init.isNegotiated(), stream, manualStream));
        DataChannel channel = new DataChannel(this, channelHandle, this.executor);
        this.channels.put(channelHandle, channel);
        return channel;
    }

    public Track addTrack(String sdp) {
        int trackHandle = Util.wrapError("rtcAddTrack", LibDataChannelNative.rtcAddTrack(this.peerHandle, sdp));
        return new Track(this, trackHandle);
    }

    public Track addTrack(TrackInit init) {
        int trackHandle = Util.wrapError("rtcAddTrackEx", LibDataChannelNative.rtcAddTrackEx(this.peerHandle, init.direction().direction, init.codec().codec));
        return new Track(this, trackHandle);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PeerConnection)) {
            return false;
        }
        PeerConnection that = (PeerConnection)o;
        return this.peerHandle == that.peerHandle;
    }

    public int hashCode() {
        return Objects.hashCode(this.peerHandle);
    }
}

