/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import tel.schich.libdatachannel.Util;

public class PeerConnectionConfiguration {
    public static final int AUTO_MTU = 0;
    public static final PeerConnectionConfiguration DEFAULT = new PeerConnectionConfiguration(Collections.emptyList(), null, null, CertificateType.DEFAULT, IceTransportPolicy.DEFAULT, false, false, false, false, 0, 0, 0, 0);
    final List<URI> iceServers;
    final @Nullable URI proxyServer;
    final @Nullable InetAddress bindAddress;
    final CertificateType certificateType;
    final IceTransportPolicy iceTransportPolicy;
    final boolean enableIceTcp;
    final boolean enableIceUdpMux;
    final boolean disableAutoNegotiation;
    final boolean forceMediaTransport;
    final short portRangeBegin;
    final short portRangeEnd;
    final int mtu;
    final int maxMessageSize;

    private PeerConnectionConfiguration(List<URI> iceServers, @Nullable URI proxyServer, @Nullable InetAddress bindAddress, CertificateType certificateType, IceTransportPolicy iceTransportPolicy, boolean enableIceTcp, boolean enableIceUdpMux, boolean disableAutoNegotiation, boolean forceMediaTransport, short portRangeBegin, short portRangeEnd, int mtu, int maxMessageSize) {
        this.iceServers = iceServers;
        this.proxyServer = proxyServer;
        this.bindAddress = bindAddress;
        this.certificateType = certificateType;
        this.iceTransportPolicy = iceTransportPolicy;
        this.enableIceTcp = enableIceTcp;
        this.enableIceUdpMux = enableIceUdpMux;
        this.disableAutoNegotiation = disableAutoNegotiation;
        this.forceMediaTransport = forceMediaTransport;
        this.portRangeBegin = portRangeBegin;
        this.portRangeEnd = portRangeEnd;
        this.mtu = mtu;
        this.maxMessageSize = maxMessageSize;
    }

    public PeerConnectionConfiguration withIceServers(Collection<URI> iceServers) {
        return new PeerConnectionConfiguration(new ArrayList<URI>(iceServers), this.proxyServer, this.bindAddress, this.certificateType, this.iceTransportPolicy, this.enableIceTcp, this.enableIceUdpMux, this.disableAutoNegotiation, this.forceMediaTransport, this.portRangeBegin, this.portRangeEnd, this.mtu, this.maxMessageSize);
    }

    public List<URI> iceServers() {
        return this.iceServers;
    }

    public PeerConnectionConfiguration withProxyServer(URI proxyServer) {
        return new PeerConnectionConfiguration(this.iceServers, proxyServer, this.bindAddress, this.certificateType, this.iceTransportPolicy, this.enableIceTcp, this.enableIceUdpMux, this.disableAutoNegotiation, this.forceMediaTransport, this.portRangeBegin, this.portRangeEnd, this.mtu, this.maxMessageSize);
    }

    public Optional<URI> proxyServer() {
        return Optional.ofNullable(this.proxyServer);
    }

    public PeerConnectionConfiguration withBindAddress(InetAddress bindAddress) {
        return new PeerConnectionConfiguration(this.iceServers, this.proxyServer, bindAddress, this.certificateType, this.iceTransportPolicy, this.enableIceTcp, this.enableIceUdpMux, this.disableAutoNegotiation, this.forceMediaTransport, this.portRangeBegin, this.portRangeEnd, this.mtu, this.maxMessageSize);
    }

    public Optional<InetAddress> bindAddress() {
        return Optional.ofNullable(this.bindAddress);
    }

    public PeerConnectionConfiguration withCertificateType(CertificateType certificateType) {
        return new PeerConnectionConfiguration(this.iceServers, this.proxyServer, this.bindAddress, certificateType, this.iceTransportPolicy, this.enableIceTcp, this.enableIceUdpMux, this.disableAutoNegotiation, this.forceMediaTransport, this.portRangeBegin, this.portRangeEnd, this.mtu, this.maxMessageSize);
    }

    public CertificateType certificateType() {
        return this.certificateType;
    }

    public PeerConnectionConfiguration iceTransportPolicy(IceTransportPolicy iceTransportPolicy) {
        return new PeerConnectionConfiguration(this.iceServers, this.proxyServer, this.bindAddress, this.certificateType, iceTransportPolicy, this.enableIceTcp, this.enableIceUdpMux, this.disableAutoNegotiation, this.forceMediaTransport, this.portRangeBegin, this.portRangeEnd, this.mtu, this.maxMessageSize);
    }

    public IceTransportPolicy iceTransportPolicy() {
        return this.iceTransportPolicy;
    }

    public PeerConnectionConfiguration withEnableIceTcp(boolean enableIceTcp) {
        return new PeerConnectionConfiguration(this.iceServers, this.proxyServer, this.bindAddress, this.certificateType, this.iceTransportPolicy, enableIceTcp, this.enableIceUdpMux, this.disableAutoNegotiation, this.forceMediaTransport, this.portRangeBegin, this.portRangeEnd, this.mtu, this.maxMessageSize);
    }

    public boolean enableIceTcp() {
        return this.enableIceTcp;
    }

    public PeerConnectionConfiguration withEnableIceUdpMux(boolean enableIceUdpMux) {
        return new PeerConnectionConfiguration(this.iceServers, this.proxyServer, this.bindAddress, this.certificateType, this.iceTransportPolicy, this.enableIceTcp, enableIceUdpMux, this.disableAutoNegotiation, this.forceMediaTransport, this.portRangeBegin, this.portRangeEnd, this.mtu, this.maxMessageSize);
    }

    public boolean enableIceUdpMux() {
        return this.enableIceUdpMux;
    }

    public PeerConnectionConfiguration withDisableAutoNegotiation(boolean disableAutoNegotiation) {
        return new PeerConnectionConfiguration(this.iceServers, this.proxyServer, this.bindAddress, this.certificateType, this.iceTransportPolicy, this.enableIceTcp, this.enableIceUdpMux, disableAutoNegotiation, this.forceMediaTransport, this.portRangeBegin, this.portRangeEnd, this.mtu, this.maxMessageSize);
    }

    public boolean disableAutoNegotiation() {
        return this.disableAutoNegotiation;
    }

    public PeerConnectionConfiguration withForceMediaTransport(boolean forceMediaTransport) {
        return new PeerConnectionConfiguration(this.iceServers, this.proxyServer, this.bindAddress, this.certificateType, this.iceTransportPolicy, this.enableIceTcp, this.enableIceUdpMux, this.disableAutoNegotiation, forceMediaTransport, this.portRangeBegin, this.portRangeEnd, this.mtu, this.maxMessageSize);
    }

    public boolean forceMediaTransport() {
        return this.forceMediaTransport;
    }

    public PeerConnectionConfiguration withPortRangeBegin(short portRangeBegin) {
        return new PeerConnectionConfiguration(this.iceServers, this.proxyServer, this.bindAddress, this.certificateType, this.iceTransportPolicy, this.enableIceTcp, this.enableIceUdpMux, this.disableAutoNegotiation, this.forceMediaTransport, portRangeBegin, this.portRangeEnd, this.mtu, this.maxMessageSize);
    }

    public short portRangeBegin() {
        return this.portRangeBegin;
    }

    public PeerConnectionConfiguration withPortRangeEnd(short portRangeEnd) {
        return new PeerConnectionConfiguration(this.iceServers, this.proxyServer, this.bindAddress, this.certificateType, this.iceTransportPolicy, this.enableIceTcp, this.enableIceUdpMux, this.disableAutoNegotiation, this.forceMediaTransport, this.portRangeBegin, portRangeEnd, this.mtu, this.maxMessageSize);
    }

    public short portRangeEnd() {
        return this.portRangeEnd;
    }

    public PeerConnectionConfiguration withMtu(int mtu) {
        return new PeerConnectionConfiguration(this.iceServers, this.proxyServer, this.bindAddress, this.certificateType, this.iceTransportPolicy, this.enableIceTcp, this.enableIceUdpMux, this.disableAutoNegotiation, this.forceMediaTransport, this.portRangeBegin, this.portRangeEnd, mtu, this.maxMessageSize);
    }

    public int mtu() {
        return this.mtu;
    }

    public PeerConnectionConfiguration withMaxMessageSize(int maxMessageSize) {
        return new PeerConnectionConfiguration(this.iceServers, this.proxyServer, this.bindAddress, this.certificateType, this.iceTransportPolicy, this.enableIceTcp, this.enableIceUdpMux, this.disableAutoNegotiation, this.forceMediaTransport, this.portRangeBegin, this.portRangeEnd, this.mtu, maxMessageSize);
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public static Collection<URI> uris(String ... uris) {
        try {
            ArrayList<URI> out = new ArrayList<URI>(uris.length);
            for (String uri : uris) {
                out.add(new URI(uri));
            }
            return out;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum IceTransportPolicy {
        RTC_TRANSPORT_POLICY_ALL(0),
        RTC_TRANSPORT_POLICY_RELAY(1);

        public static final IceTransportPolicy DEFAULT;
        private static final Map<Integer, IceTransportPolicy> MAP;
        final int state;

        private IceTransportPolicy(int state) {
            this.state = state;
        }

        public static @Nullable IceTransportPolicy of(int state) {
            return MAP.get(state);
        }

        static {
            DEFAULT = RTC_TRANSPORT_POLICY_ALL;
            MAP = Util.mappedEnum((Enum[])IceTransportPolicy.values(), s -> s.state);
        }
    }

    public static enum CertificateType {
        RTC_CERTIFICATE_DEFAULT(0),
        RTC_CERTIFICATE_ECDSA(1),
        RTC_CERTIFICATE_RSA(2);

        public static final CertificateType DEFAULT;
        private static final Map<Integer, CertificateType> MAP;
        final int state;

        private CertificateType(int state) {
            this.state = state;
        }

        public static @Nullable CertificateType of(int state) {
            return MAP.get(state);
        }

        static {
            DEFAULT = RTC_CERTIFICATE_DEFAULT;
            MAP = Util.mappedEnum((Enum[])CertificateType.values(), s -> s.state);
        }
    }
}

