/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tel.schich.libdatachannel.DataChannel;
import tel.schich.libdatachannel.DataChannelCallback;
import tel.schich.libdatachannel.EventListenerContainer;
import tel.schich.libdatachannel.GatheringState;
import tel.schich.libdatachannel.IceState;
import tel.schich.libdatachannel.PeerConnection;
import tel.schich.libdatachannel.PeerState;
import tel.schich.libdatachannel.SessionDescriptionType;
import tel.schich.libdatachannel.SignalingState;
import tel.schich.libdatachannel.Track;

class PeerConnectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerConnectionListener.class);
    private final PeerConnection peer;

    public PeerConnectionListener(PeerConnection peer) {
        this.peer = peer;
    }

    void onLocalDescription(String sdp, String type) {
        SessionDescriptionType mappedType = SessionDescriptionType.of(type);
        if (mappedType == null) {
            LOGGER.error("Unknown SDP type {}!", (Object)type);
            return;
        }
        this.peer.onLocalDescription.invoke(h -> h.handleDescription(this.peer, sdp, mappedType));
    }

    void onLocalCandidate(String candidate, String mediaId) {
        this.peer.onLocalCandidate.invoke(h -> h.handleCandidate(this.peer, candidate, mediaId));
    }

    void onStateChange(int state) {
        PeerState mappedState = PeerState.of(state);
        if (mappedState == null) {
            LOGGER.error("Unknown state {}!", (Object)state);
            return;
        }
        this.peer.onStateChange.invoke(h -> h.handleChange(this.peer, mappedState));
    }

    void onIceStateChange(int iceState) {
        IceState mappedState = IceState.of(iceState);
        if (mappedState == null) {
            LOGGER.error("Unknown ICE state {}!", (Object)iceState);
            return;
        }
        this.peer.onIceStateChange.invoke(h -> h.handleChange(this.peer, mappedState));
    }

    void onGatheringStateChange(int gatheringState) {
        GatheringState mappedState = GatheringState.of(gatheringState);
        if (mappedState == null) {
            LOGGER.error("Unknown gathering state {}!", (Object)gatheringState);
            return;
        }
        this.peer.onGatheringStateChange.invoke(h -> h.handleChange(this.peer, mappedState));
    }

    void onSignalingStateChange(int signalingState) {
        SignalingState mappedState = SignalingState.of(signalingState);
        if (mappedState == null) {
            LOGGER.error("Unknown signaling state {}!", (Object)signalingState);
            return;
        }
        this.peer.onSignalingStateChange.invoke(h -> h.handleChange(this.peer, mappedState));
    }

    void onDataChannel(int channelHandle) {
        DataChannel channel = this.peer.newChannel(channelHandle);
        this.peer.onDataChannel.invoke(h -> h.handleChannel(this.peer, channel));
    }

    void onTrack(int trackHandle) {
        Track state = this.peer.newTrack(trackHandle);
        this.peer.onTrack.invoke(h -> h.handleTrack(this.peer, state));
    }

    private <T> void invokeWithChannel(int handle, Function<DataChannel, EventListenerContainer<T>> listeners, BiConsumer<T, DataChannel> consumer) {
        DataChannel channel = this.peer.channel(handle);
        if (channel == null) {
            LOGGER.warn("Received event for unknown data channel {}!", (Object)handle);
            return;
        }
        listeners.apply(channel).invoke(h -> consumer.accept(h, channel));
    }

    void onChannelOpen(int channelHandle) {
        this.invokeWithChannel(channelHandle, s -> s.onOpen, DataChannelCallback.Open::onOpen);
    }

    void onChannelClosed(int channelHandle) {
        this.invokeWithChannel(channelHandle, s -> s.onClosed, DataChannelCallback.Closed::onClosed);
    }

    void onChannelError(int channelHandle, String error) {
        this.invokeWithChannel(channelHandle, s -> s.onError, (h, ch) -> h.onError((DataChannel)ch, error));
    }

    void onChannelTextMessage(int channelHandle, String message) {
        this.invokeWithChannel(channelHandle, s -> s.onMessage, (h, ch) -> h.onText((DataChannel)ch, message));
    }

    void onChannelBinaryMessage(int channelHandle, ByteBuffer message) {
        this.invokeWithChannel(channelHandle, s -> s.onMessage, (h, ch) -> h.onBinary((DataChannel)ch, message));
    }

    void onChannelBufferedAmountLow(int channelHandle) {
        this.invokeWithChannel(channelHandle, s -> s.onBufferedAmountLow, DataChannelCallback.BufferedAmountLow::onBufferedAmountLow);
    }

    void onChannelAvailable(int channelHandle) {
        this.invokeWithChannel(channelHandle, s -> s.onAvailable, DataChannelCallback.Available::onAvailable);
    }
}

