/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Platform {
    private static final Logger LOGGER = LoggerFactory.getLogger(Platform.class);
    private static final String LIB_PREFIX = "/native";
    private static final String PATH_PROP_PREFIX = "libdatachannel.native.";
    private static final String PATH_PROP_FS_PATH = ".path";
    private static final String PATH_PROP_CLASS_PATH = ".classpath";

    Platform() {
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").equalsIgnoreCase("Linux");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static boolean isAndroid() {
        try {
            return System.getProperty("java.specification.vendor").contains("Android") || System.getProperty("java.vendor").contains("Android") || System.getProperty("java.vm.vendor").contains("Android");
        }
        catch (SecurityException e) {
            return System.getProperty("java.vm.name").toLowerCase().contains("dalvik") || System.getProperty("java.vm.name").toLowerCase().contains("art");
        }
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    public static OS getOS() {
        if (Platform.isLinux()) {
            return OS.LINUX;
        }
        if (Platform.isAndroid()) {
            return OS.ANDROID;
        }
        if (Platform.isMacOS()) {
            return OS.MACOS;
        }
        if (Platform.isWindows()) {
            return OS.WINDOWS;
        }
        return OS.UNKNOWN;
    }

    public static void loadNativeLibrary(String name, Class<?> base) {
        try {
            System.loadLibrary(name);
            LOGGER.trace("Loaded native library {} from library path", (Object)name);
        }
        catch (LinkageError e) {
            Platform.loadExplicitLibrary(name, base);
        }
    }

    public static String classPathPropertyNameForLibrary(String name) {
        return PATH_PROP_PREFIX + name.toLowerCase() + PATH_PROP_CLASS_PATH;
    }

    private static String archPrefixForOs() {
        if (Platform.getOS() == OS.WINDOWS) {
            return "windows-";
        }
        if (Platform.getOS() == OS.ANDROID) {
            return "android-";
        }
        if (Platform.getOS() == OS.MACOS) {
            return "macos-";
        }
        return "";
    }

    private static String detectCpuArch() {
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.contains("arm")) {
            return "armv7";
        }
        if (arch.contains("86") || arch.contains("amd")) {
            if (arch.contains("64")) {
                return "x86_64";
            }
            return "x86_32";
        }
        if (arch.contains("riscv")) {
            if (arch.contains("64")) {
                return "riscv64";
            }
            return "riscv32";
        }
        if (arch.contains("aarch64") || arch.contains("arm64")) {
            if (Platform.getOS() == OS.MACOS) {
                return "arm64";
            }
            return "aarch64";
        }
        return arch;
    }

    public static String detectArch() {
        return Platform.archPrefixForOs() + Platform.detectCpuArch();
    }

    public static String libraryFilename(String name) {
        String libName = "lib" + name;
        if (Platform.getOS() == OS.WINDOWS) {
            return libName + ".dll";
        }
        if (Platform.getOS() == OS.MACOS) {
            return libName + ".dylib";
        }
        return libName + ".so";
    }

    private static void loadExplicitLibrary(String name, Class<?> base) {
        String explicitLibraryPath = System.getProperty(PATH_PROP_PREFIX + name.toLowerCase() + PATH_PROP_FS_PATH);
        if (explicitLibraryPath != null) {
            LOGGER.trace("Loading native library {} from {}", (Object)name, (Object)explicitLibraryPath);
            System.load(explicitLibraryPath);
            return;
        }
        String explicitLibraryClassPath = System.getProperty(Platform.classPathPropertyNameForLibrary(name));
        String libName = Platform.libraryFilename(name);
        if (explicitLibraryClassPath != null) {
            LOGGER.trace("Loading native library {} from explicit classpath at {}", (Object)name, (Object)explicitLibraryClassPath);
            try {
                Path tempDirectory = Files.createTempDirectory(name + "-", new FileAttribute[0]);
                Path libPath = tempDirectory.resolve(libName);
                Platform.loadFromClassPath(name, base, explicitLibraryClassPath, libPath);
                return;
            }
            catch (IOException e) {
                throw new LinkageError("Unable to load native library " + name + "!", e);
            }
        }
        String sourceLibPath = "/native/" + libName;
        LOGGER.trace("Loading native library {} from {}", (Object)name, (Object)sourceLibPath);
        try {
            Path tempDirectory = Files.createTempDirectory(name + "-", new FileAttribute[0]);
            Path libPath = tempDirectory.resolve(libName);
            Platform.loadFromClassPath(name, base, sourceLibPath, libPath);
        }
        catch (IOException e) {
            throw new LinkageError("Unable to load native library " + name + "!", e);
        }
    }

    private static void loadFromClassPath(String name, Class<?> base, String classPath, Path fsPath) throws IOException {
        try (InputStream libStream = base.getResourceAsStream(classPath);){
            if (libStream == null) {
                throw new LinkageError("Failed to load the native library " + name + ": " + classPath + " not found.");
            }
            Files.copy(libStream, fsPath, StandardCopyOption.REPLACE_EXISTING);
            System.load(fsPath.toString());
            fsPath.toFile().deleteOnExit();
        }
    }

    public static enum OS {
        LINUX,
        WINDOWS,
        ANDROID,
        MACOS,
        UNKNOWN;

    }
}

