/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.io.Closeable;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import tel.schich.libdatachannel.LibDataChannelNative;
import tel.schich.libdatachannel.PeerConnection;
import tel.schich.libdatachannel.Util;

public class Track
implements Closeable {
    private final PeerConnection peer;
    private final int trackHandle;

    public Track(PeerConnection peer, int trackHandle) {
        this.peer = peer;
        this.trackHandle = trackHandle;
    }

    public PeerConnection peer() {
        return this.peer;
    }

    public String description() {
        return LibDataChannelNative.rtcGetTrackDescription(this.trackHandle);
    }

    public String mediaId() {
        return LibDataChannelNative.rtcGetTrackMid(this.trackHandle);
    }

    public Direction direction() {
        int directionInt = LibDataChannelNative.rtcGetTrackDirection(this.trackHandle);
        Direction direction = Direction.of(directionInt);
        if (direction == null) {
            throw new IllegalStateException("Unknown track direction: " + directionInt);
        }
        return direction;
    }

    @Override
    public void close() {
        this.peer.dropTrackState(this.trackHandle);
        Util.wrapError("rtcDeleteTrack", LibDataChannelNative.rtcDeleteTrack(this.trackHandle));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Track)) {
            return false;
        }
        Track track = (Track)o;
        return this.trackHandle == track.trackHandle;
    }

    public int hashCode() {
        return Objects.hashCode(this.trackHandle);
    }

    public static enum Codec {
        RTC_CODEC_H264(0),
        RTC_CODEC_VP8(1),
        RTC_CODEC_VP9(2),
        RTC_CODEC_H265(3),
        RTC_CODEC_AV1(4),
        RTC_CODEC_OPUS(128),
        RTC_CODEC_PCMU(129),
        RTC_CODEC_PCMA(130),
        RTC_CODEC_AAC(131);

        public static final Codec DEFAULT;
        private static final Map<Integer, Codec> MAP;
        final int codec;

        private Codec(int codec) {
            this.codec = codec;
        }

        static @Nullable Codec of(int codec) {
            return MAP.get(codec);
        }

        static {
            DEFAULT = RTC_CODEC_H264;
            MAP = Util.mappedEnum((Enum[])Codec.values(), s -> s.codec);
        }
    }

    public static enum Direction {
        RTC_DIRECTION_UNKNOWN(0),
        RTC_DIRECTION_SENDONLY(1),
        RTC_DIRECTION_RECVONLY(2),
        RTC_DIRECTION_SENDRECV(3),
        RTC_DIRECTION_INACTIVE(4);

        public static final Direction DEFAULT;
        private static final Map<Integer, Direction> MAP;
        final int direction;

        private Direction(int direction) {
            this.direction = direction;
        }

        public static @Nullable Direction of(int direction) {
            return MAP.get(direction);
        }

        static {
            DEFAULT = RTC_DIRECTION_UNKNOWN;
            MAP = Util.mappedEnum((Enum[])Direction.values(), s -> s.direction);
        }
    }
}

