/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.libdatachannel;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import tel.schich.libdatachannel.exception.FailureException;
import tel.schich.libdatachannel.exception.InvalidException;
import tel.schich.libdatachannel.exception.LibDataChannelException;
import tel.schich.libdatachannel.exception.NotAvailableException;
import tel.schich.libdatachannel.exception.TooSmallException;
import tel.schich.libdatachannel.exception.UnknownFailureException;

class Util {
    Util() {
    }

    static void ensureDirect(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("data must be a direct ByteBuffer!");
        }
    }

    static InetSocketAddress parseAddress(String rawAddress) {
        int colonIndex = rawAddress.lastIndexOf(58);
        String ip = rawAddress.substring(0, colonIndex);
        int port = Integer.parseInt(rawAddress.substring(colonIndex + 1));
        return InetSocketAddress.createUnresolved(ip, port);
    }

    static <T extends Enum<T>, K> Map<K, T> mappedEnum(T[] values, Function<T, K> mapper) {
        return Arrays.stream(values).collect(Collectors.toMap(mapper, s -> s));
    }

    static int wrapError(String operation, int result) throws LibDataChannelException {
        if (result > 0) {
            return result;
        }
        switch (result) {
            case 0: {
                return 0;
            }
            case -1: {
                throw new InvalidException(operation);
            }
            case -2: {
                throw new FailureException(operation);
            }
            case -3: {
                throw new NotAvailableException(operation);
            }
            case -4: {
                throw new TooSmallException(operation);
            }
        }
        throw new UnknownFailureException(result, operation);
    }
}

